/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.nativechecker;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.sidecar.nativechecker.NativePlanChecker;
import com.facebook.presto.sidecar.nativechecker.NativePlanCheckerConfig;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.plan.PlanChecker;
import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;

public class NativePlanCheckerProvider
implements PlanCheckerProvider {
    private final NodeManager nodeManager;
    private final JsonCodec<SimplePlanFragment> planFragmentJsonCodec;
    private final NativePlanCheckerConfig config;

    @Inject
    public NativePlanCheckerProvider(NodeManager nodeManager, JsonCodec<SimplePlanFragment> planFragmentJsonCodec, NativePlanCheckerConfig config) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.planFragmentJsonCodec = Objects.requireNonNull(planFragmentJsonCodec, "planFragmentJsonCodec is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public List<PlanChecker> getFragmentPlanCheckers() {
        return this.config.isPlanValidationEnabled() ? ImmutableList.of((Object)new NativePlanChecker(this.nodeManager, this.planFragmentJsonCodec)) : ImmutableList.of();
    }
}

