/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutorsModule;
import com.facebook.presto.sidecar.NativeSidecarCommunicationModule;
import com.facebook.presto.sidecar.functionNamespace.NativeFunctionNamespaceManager;
import com.facebook.presto.sidecar.functionNamespace.NativeFunctionNamespaceManagerModule;
import com.facebook.presto.spi.function.FunctionHandleResolver;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerContext;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;

public class NativeFunctionNamespaceManagerFactory
implements FunctionNamespaceManagerFactory {
    public static final String NAME = "native";
    private static final SqlFunctionHandle.Resolver HANDLE_RESOLVER = SqlFunctionHandle.Resolver.getInstance();

    public String getName() {
        return NAME;
    }

    public FunctionHandleResolver getHandleResolver() {
        return HANDLE_RESOLVER;
    }

    public FunctionNamespaceManager<?> create(String catalogName, Map<String, String> config, FunctionNamespaceManagerContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new NativeFunctionNamespaceManagerModule(catalogName, context.getNodeManager(), context.getFunctionMetadataManager()), new NoopSqlFunctionExecutorsModule(), new NativeSidecarCommunicationModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (FunctionNamespaceManager)injector.getInstance(NativeFunctionNamespaceManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

