/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.typemanager;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class NativeTypeManager
implements TypeManager {
    private static final Logger log = Logger.get(NativeTypeManager.class);
    private static final Set<String> NATIVE_ENGINE_SUPPORTED_TYPES = ImmutableSet.of((Object)"bigint", (Object)"real", (Object)"varbinary", (Object)"timestamp", (Object)"tinyint", (Object)"boolean", (Object[])new String[]{"date", "integer", "double", "smallint", "HyperLogLog", "json", "timestamp with time zone", "uuid", "ipaddress", "ipprefix", "interval day to second", "interval year to month", "varchar", "unknown"});
    private static final Set<String> NATIVE_ENGINE_SUPPORTED_PARAMETRIC_TYPES = ImmutableSet.of((Object)"array", (Object)"decimal", (Object)"map", (Object)"row", (Object)"function");
    private final TypeManager typeManager;
    private final LoadingCache<ExactTypeSignature, Type> parametricTypeCache;
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();

    @Inject
    public NativeTypeManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.parametricTypeCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::instantiateParametricType));
        this.addAllTypes(NativeTypeManager.filterSupportedTypes(NATIVE_ENGINE_SUPPORTED_TYPES, typeManager.getTypes(), Type::getDisplayName), NativeTypeManager.filterSupportedTypes(NATIVE_ENGINE_SUPPORTED_PARAMETRIC_TYPES, new ArrayList(typeManager.getParametricTypes()), ParametricType::getName));
    }

    public Type getType(TypeSignature typeSignature) {
        Type type;
        if (typeSignature.getBase().equals("varchar")) {
            typeSignature = VarcharType.createUnboundedVarcharType().getTypeSignature();
        }
        if ((type = (Type)this.types.get(typeSignature)) != null) {
            return type;
        }
        try {
            return (Type)this.parametricTypeCache.getUnchecked((Object)new ExactTypeSignature(typeSignature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    public Collection<ParametricType> getParametricTypes() {
        return this.parametricTypes.values();
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        throw new UnsupportedOperationException();
    }

    public boolean canCoerce(Type actualType, Type expectedType) {
        throw new UnsupportedOperationException();
    }

    private void addAllTypes(List<Type> typesList, List<ParametricType> parametricTypesList) {
        typesList.forEach(this::addType);
        this.addType((Type)VarcharType.VARCHAR);
        parametricTypesList.forEach(this::addParametricType);
    }

    private Type instantiateParametricType(ExactTypeSignature exactTypeSignature) {
        return this.typeManager.instantiateParametricType(exactTypeSignature.getTypeSignature());
    }

    private void addType(Type type) {
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object)type);
    }

    private void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object)name);
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    private static <T> List<T> filterSupportedTypes(Set<String> actualTypes, List<T> types, Function<T, String> typeSignatureExtractor) {
        return (List)types.stream().filter(type -> actualTypes.contains(typeSignatureExtractor.apply(type))).collect(ImmutableList.toImmutableList());
    }

    private static class ExactTypeSignature {
        private final TypeSignature typeSignature;

        public ExactTypeSignature(TypeSignature typeSignature) {
            this.typeSignature = typeSignature;
        }

        public TypeSignature getTypeSignature() {
            return this.typeSignature;
        }

        public int hashCode() {
            return Objects.hash(this.typeSignature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactTypeSignature other = (ExactTypeSignature)o;
            return ExactTypeSignature.equals(this.typeSignature, other.typeSignature);
        }

        private static boolean equals(TypeSignature left, TypeSignature right) {
            if (!left.equals((Object)right)) {
                return false;
            }
            if (left.isDistinctType() && right.isDistinctType()) {
                return ExactTypeSignature.equals(left.getDistinctTypeInfo(), right.getDistinctTypeInfo());
            }
            int index = 0;
            for (TypeSignatureParameter leftParameter : left.getParameters()) {
                TypeSignatureParameter rightParameter = (TypeSignatureParameter)right.getParameters().get(index++);
                if (!leftParameter.getKind().equals((Object)rightParameter.getKind())) {
                    return false;
                }
                switch (leftParameter.getKind()) {
                    case TYPE: {
                        if (ExactTypeSignature.equals(leftParameter.getTypeSignature(), rightParameter.getTypeSignature())) break;
                        return false;
                    }
                    case NAMED_TYPE: {
                        if (ExactTypeSignature.equals(leftParameter.getNamedTypeSignature().getTypeSignature(), rightParameter.getNamedTypeSignature().getTypeSignature())) break;
                        return false;
                    }
                    case DISTINCT_TYPE: {
                        if (ExactTypeSignature.equals(leftParameter.getDistinctTypeInfo(), rightParameter.getDistinctTypeInfo())) break;
                        return false;
                    }
                }
            }
            return true;
        }

        private static boolean equals(DistinctTypeInfo left, DistinctTypeInfo right) {
            return Objects.equals(left.getName(), right.getName()) && Objects.equals(left.getBaseType(), right.getBaseType()) && Objects.equals(left.isOrderable(), right.isOrderable()) && Objects.equals(left.getTopMostAncestor(), right.getTopMostAncestor()) && Objects.equals(left.getOtherAncestors(), right.getOtherAncestors());
        }
    }
}

