/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.common.Page;
import com.facebook.presto.plugin.memory.MemoryColumnHandle;
import com.facebook.presto.plugin.memory.MemoryPagesStore;
import com.facebook.presto.plugin.memory.MemorySplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MemoryPageSourceProvider
implements ConnectorPageSourceProvider {
    private final MemoryPagesStore pagesStore;

    @Inject
    public MemoryPageSourceProvider(MemoryPagesStore pagesStore) {
        this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        MemorySplit memorySplit = (MemorySplit)split;
        long tableId = memorySplit.getTableHandle().getTableId();
        int partNumber = memorySplit.getPartNumber();
        int totalParts = memorySplit.getTotalPartsPerWorker();
        long expectedRows = memorySplit.getExpectedRows();
        List<Integer> columnIndexes = columns.stream().map(MemoryColumnHandle.class::cast).map(MemoryColumnHandle::getColumnIndex).collect(Collectors.toList());
        List<Page> pages = this.pagesStore.getPages(tableId, partNumber, totalParts, columnIndexes, expectedRows);
        return new FixedPageSource(pages);
    }
}

