/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.common.Page;
import com.facebook.presto.plugin.memory.MemoryDataFragment;
import com.facebook.presto.plugin.memory.MemoryInsertTableHandle;
import com.facebook.presto.plugin.memory.MemoryOutputTableHandle;
import com.facebook.presto.plugin.memory.MemoryPagesStore;
import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class MemoryPageSinkProvider
implements ConnectorPageSinkProvider {
    private final MemoryPagesStore pagesStore;
    private final HostAddress currentHostAddress;

    @Inject
    public MemoryPageSinkProvider(MemoryPagesStore pagesStore, NodeManager nodeManager) {
        this(pagesStore, Objects.requireNonNull(nodeManager, "nodeManager is null").getCurrentNode().getHostAndPort());
    }

    @VisibleForTesting
    public MemoryPageSinkProvider(MemoryPagesStore pagesStore, HostAddress currentHostAddress) {
        this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
        this.currentHostAddress = Objects.requireNonNull(currentHostAddress, "currentHostAddress is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Memory connector does not support page sink commit");
        MemoryOutputTableHandle memoryOutputTableHandle = (MemoryOutputTableHandle)outputTableHandle;
        MemoryTableHandle tableHandle = memoryOutputTableHandle.getTable();
        long tableId = tableHandle.getTableId();
        Preconditions.checkState((boolean)memoryOutputTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryOutputTableHandle.getActiveTableIds());
        this.pagesStore.initialize(tableId);
        return new MemoryPageSink(this.pagesStore, this.currentHostAddress, tableId);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Memory connector does not support page sink commit");
        MemoryInsertTableHandle memoryInsertTableHandle = (MemoryInsertTableHandle)insertTableHandle;
        MemoryTableHandle tableHandle = memoryInsertTableHandle.getTable();
        long tableId = tableHandle.getTableId();
        Preconditions.checkState((boolean)memoryInsertTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryInsertTableHandle.getActiveTableIds());
        if (memoryInsertTableHandle.isInsertOverwrite()) {
            this.pagesStore.clearTable(tableId);
        }
        this.pagesStore.initialize(tableId);
        return new MemoryPageSink(this.pagesStore, this.currentHostAddress, tableId);
    }

    private static class MemoryPageSink
    implements ConnectorPageSink {
        private final MemoryPagesStore pagesStore;
        private final HostAddress currentHostAddress;
        private final long tableId;
        private long addedRows;

        public MemoryPageSink(MemoryPagesStore pagesStore, HostAddress currentHostAddress, long tableId) {
            this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
            this.currentHostAddress = Objects.requireNonNull(currentHostAddress, "currentHostAddress is null");
            this.tableId = tableId;
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.pagesStore.add(this.tableId, page);
            this.addedRows += (long)page.getPositionCount();
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)new MemoryDataFragment(this.currentHostAddress, this.addedRows).toSlice()));
        }

        public void abort() {
        }
    }
}

