/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.plugin.memory.MemoryColumnHandle;
import com.facebook.presto.plugin.memory.MemoryConnectorId;
import com.facebook.presto.plugin.memory.MemoryDataFragment;
import com.facebook.presto.plugin.memory.MemoryInsertTableHandle;
import com.facebook.presto.plugin.memory.MemoryOutputTableHandle;
import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.plugin.memory.MemoryTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.slice.Slice;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;

@ThreadSafe
public class MemoryMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final NodeManager nodeManager;
    private final String connectorId;
    private final List<String> schemas = new ArrayList<String>();
    private final AtomicLong nextTableId = new AtomicLong();
    private final Map<SchemaTableName, Long> tableIds = new HashMap<SchemaTableName, Long>();
    private final Map<Long, MemoryTableHandle> tables = new HashMap<Long, MemoryTableHandle>();
    private final Map<Long, Map<HostAddress, MemoryDataFragment>> tableDataFragments = new HashMap<Long, Map<HostAddress, MemoryDataFragment>>();
    private final Map<SchemaTableName, String> views = new HashMap<SchemaTableName, String>();

    @Inject
    public MemoryMetadata(NodeManager nodeManager, MemoryConnectorId connectorId) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.schemas.add(SCHEMA_NAME);
    }

    public synchronized List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        if (this.schemas.contains(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public synchronized void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Schema [%s] does not exist", schemaName));
        }
        boolean tablesExist = this.tables.values().stream().anyMatch(table -> table.getSchemaName().equals(schemaName));
        if (tablesExist) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        Verify.verify((boolean)this.schemas.remove(schemaName));
    }

    public synchronized ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        Long tableId = this.tableIds.get(schemaTableName);
        if (tableId == null) {
            return null;
        }
        return this.tables.get(tableId);
    }

    public synchronized ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return memoryTableHandle.toTableMetadata();
    }

    public synchronized List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.tables.values().stream().filter(table -> schemaNameOrNull == null || table.getSchemaName().equals(schemaNameOrNull)).map(MemoryTableHandle::toSchemaTableName).collect(Collectors.toList());
    }

    public synchronized Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return memoryTableHandle.getColumnHandles().stream().collect(Collectors.toMap(MemoryColumnHandle::getName, Function.identity()));
    }

    public synchronized ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        MemoryColumnHandle memoryColumnHandle = (MemoryColumnHandle)columnHandle;
        return memoryColumnHandle.toColumnMetadata();
    }

    public synchronized Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).collect(ImmutableMap.toImmutableMap(MemoryTableHandle::toSchemaTableName, handle -> this.toTableMetadata((MemoryTableHandle)handle, session).getColumns()));
    }

    public ConnectorTableMetadata toTableMetadata(MemoryTableHandle memoryTableHandle, ConnectorSession session) {
        List columns = (List)memoryTableHandle.getColumnHandles().stream().map(column -> column.toColumnMetadata(this.normalizeIdentifier(session, column.getName()))).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(memoryTableHandle.toSchemaTableName(), columns);
    }

    public synchronized void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        Long tableId = this.tableIds.remove(handle.toSchemaTableName());
        if (tableId != null) {
            this.tables.remove(tableId);
            this.tableDataFragments.remove(tableId);
        }
    }

    public synchronized void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.checkSchemaExists(newTableName.getSchemaName());
        this.checkTableNotExists(newTableName);
        MemoryTableHandle oldTableHandle = (MemoryTableHandle)tableHandle;
        MemoryTableHandle newTableHandle = new MemoryTableHandle(oldTableHandle.getConnectorId(), newTableName.getSchemaName(), newTableName.getTableName(), oldTableHandle.getTableId(), oldTableHandle.getColumnHandles());
        this.tableIds.remove(oldTableHandle.toSchemaTableName());
        this.tableIds.put(newTableName, oldTableHandle.getTableId());
        this.tables.remove(oldTableHandle.getTableId());
        this.tables.put(oldTableHandle.getTableId(), newTableHandle);
    }

    public synchronized void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public synchronized MemoryOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        this.checkTableNotExists(tableMetadata.getTable());
        long nextId = this.nextTableId.getAndIncrement();
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Memory nodes available");
        this.tableIds.put(tableMetadata.getTable(), nextId);
        MemoryTableHandle table = new MemoryTableHandle(this.connectorId, nextId, tableMetadata);
        this.tables.put(table.getTableId(), table);
        this.tableDataFragments.put(table.getTableId(), new HashMap());
        return new MemoryOutputTableHandle(table, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }

    private void checkTableNotExists(SchemaTableName tableName) {
        if (this.tables.values().stream().map(MemoryTableHandle::toSchemaTableName).anyMatch(arg_0 -> ((SchemaTableName)tableName).equals(arg_0))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Table [%s] already exists", tableName.toString()));
        }
        if (this.views.keySet().contains(tableName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("View [%s] already exists", tableName.toString()));
        }
    }

    public synchronized Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        MemoryOutputTableHandle memoryOutputHandle = (MemoryOutputTableHandle)tableHandle;
        this.updateRowsOnHosts(memoryOutputHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized MemoryInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return new MemoryInsertTableHandle(memoryTableHandle, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    public synchronized Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(insertHandle, "insertHandle is null");
        MemoryInsertTableHandle memoryInsertHandle = (MemoryInsertTableHandle)insertHandle;
        this.updateRowsOnHosts(memoryInsertHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized void createView(ConnectorSession session, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        SchemaTableName viewName = viewMetadata.getTable();
        this.checkSchemaExists(viewName.getSchemaName());
        if (this.getTableHandle(session, viewName) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists: " + viewName);
        }
        if (replace) {
            this.views.put(viewName, viewData);
        } else if (this.views.putIfAbsent(viewName, viewData) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
        }
    }

    public synchronized void renameView(ConnectorSession session, SchemaTableName viewName, SchemaTableName newViewName) {
        this.checkSchemaExists(newViewName.getSchemaName());
        if (this.tableIds.containsKey(newViewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists: " + newViewName);
        }
        if (this.views.containsKey(newViewName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + newViewName);
        }
        this.views.put(newViewName, this.views.remove(viewName));
    }

    public synchronized void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public synchronized List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return (List)this.views.keySet().stream().filter(viewName -> schemaNameOrNull == null || schemaNameOrNull.equals(viewName.getSchemaName())).collect(ImmutableList.toImmutableList());
    }

    public synchronized Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)this.views.entrySet().stream().filter(entry -> prefix.matches((SchemaTableName)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new ConnectorViewDefinition((SchemaTableName)entry.getKey(), Optional.empty(), (String)entry.getValue())));
    }

    private void updateRowsOnHosts(MemoryTableHandle table, Collection<Slice> fragments) {
        Preconditions.checkState((boolean)this.tableDataFragments.containsKey(table.getTableId()), (String)"Uninitialized table [%s.%s]", (Object)table.getSchemaName(), (Object)table.getTableName());
        Map<HostAddress, MemoryDataFragment> dataFragments = this.tableDataFragments.get(table.getTableId());
        for (Slice fragment : fragments) {
            MemoryDataFragment memoryDataFragment = MemoryDataFragment.fromSlice(fragment);
            dataFragments.merge(memoryDataFragment.getHostAddress(), memoryDataFragment, MemoryDataFragment::merge);
        }
    }

    public synchronized ConnectorTableLayoutResult getTableLayoutForConstraint(ConnectorSession session, ConnectorTableHandle handle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        Objects.requireNonNull(handle, "handle is null");
        Preconditions.checkArgument((boolean)(handle instanceof MemoryTableHandle));
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)handle;
        Preconditions.checkState((boolean)this.tableDataFragments.containsKey(memoryTableHandle.getTableId()), (String)"Inconsistent state for the table [%s.%s]", (Object)memoryTableHandle.getSchemaName(), (Object)memoryTableHandle.getTableName());
        ImmutableList expectedFragments = ImmutableList.copyOf(this.tableDataFragments.get(memoryTableHandle.getTableId()).values());
        MemoryTableLayoutHandle layoutHandle = new MemoryTableLayoutHandle(memoryTableHandle, (List<MemoryDataFragment>)expectedFragments);
        return new ConnectorTableLayoutResult(this.getTableLayout(session, layoutHandle), constraint.getSummary());
    }

    public synchronized ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle, Optional.empty(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }
}

