/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class MemoryColumnHandle
implements ColumnHandle {
    private final String name;
    private final Type columnType;
    private final int columnIndex;

    public MemoryColumnHandle(ColumnMetadata columnMetadata, int columnIndex) {
        this(columnMetadata.getName(), columnMetadata.getType(), columnIndex);
    }

    @JsonCreator
    public MemoryColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="columnIndex") int columnIndex) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.columnIndex = columnIndex;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public ColumnMetadata toColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.columnType).build();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.columnType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryColumnHandle other = (MemoryColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.columnType, other.columnType) && Objects.equals(this.columnIndex, other.columnIndex);
    }

    public static List<MemoryColumnHandle> extractColumnHandles(List<ColumnMetadata> columns) {
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int columnIndex = 0;
        for (ColumnMetadata column : columns) {
            columnHandles.add((Object)new MemoryColumnHandle(column, columnIndex));
            ++columnIndex;
        }
        return columnHandles.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("columnType", (Object)this.columnType).add("columnIndex", this.columnIndex).toString();
    }
}

