/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryConnector;
import com.facebook.presto.plugin.memory.MemoryHandleResolver;
import com.facebook.presto.plugin.memory.MemoryModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;

public class MemoryConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "memory";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new MemoryHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MemoryModule(connectorId, context.getTypeManager(), context.getNodeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            return (Connector)injector.getInstance(MemoryConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

