/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryConfig;
import com.facebook.presto.plugin.memory.MemoryDataFragment;
import com.facebook.presto.plugin.memory.MemorySplit;
import com.facebook.presto.plugin.memory.MemoryTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public final class MemorySplitManager
implements ConnectorSplitManager {
    private final int splitsPerNode;

    @Inject
    public MemorySplitManager(MemoryConfig config) {
        this.splitsPerNode = config.getSplitsPerNode();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        MemoryTableLayoutHandle layout = (MemoryTableLayoutHandle)layoutHandle;
        List<MemoryDataFragment> dataFragments = layout.getDataFragments();
        ImmutableList.Builder splits = ImmutableList.builder();
        for (MemoryDataFragment dataFragment : dataFragments) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new MemorySplit(layout.getTable(), i, this.splitsPerNode, dataFragment.getHostAddress(), dataFragment.getRows()));
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

