/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryInsertTableHandle;
import com.facebook.presto.plugin.memory.MemoryOutputTableHandle;
import com.facebook.presto.plugin.memory.MemoryPagesStore;
import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class MemoryPageSinkProvider
implements ConnectorPageSinkProvider {
    private final MemoryPagesStore pagesStore;

    @Inject
    public MemoryPageSinkProvider(MemoryPagesStore pagesStore) {
        this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        MemoryOutputTableHandle memoryOutputTableHandle = (MemoryOutputTableHandle)outputTableHandle;
        MemoryTableHandle tableHandle = memoryOutputTableHandle.getTable();
        long tableId = tableHandle.getTableId();
        Preconditions.checkState((boolean)memoryOutputTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryOutputTableHandle.getActiveTableIds());
        this.pagesStore.initialize(tableId);
        return new MemoryPageSink(this.pagesStore, tableId);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        MemoryInsertTableHandle memoryInsertTableHandle = (MemoryInsertTableHandle)insertTableHandle;
        MemoryTableHandle tableHandle = memoryInsertTableHandle.getTable();
        long tableId = tableHandle.getTableId();
        Preconditions.checkState((boolean)memoryInsertTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryInsertTableHandle.getActiveTableIds());
        return new MemoryPageSink(this.pagesStore, tableId);
    }

    private static class MemoryPageSink
    implements ConnectorPageSink {
        private final MemoryPagesStore pagesStore;
        private final long tableId;

        public MemoryPageSink(MemoryPagesStore pagesStore, long tableId) {
            this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
            this.tableId = tableId;
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.pagesStore.add(this.tableId, page);
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }

        public void abort() {
        }
    }
}

