/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MemorySplit
implements ConnectorSplit {
    private final MemoryTableHandle tableHandle;
    private final int totalPartsPerWorker;
    private final int partNumber;
    private final List<HostAddress> addresses;

    @JsonCreator
    public MemorySplit(@JsonProperty(value="tableHandle") MemoryTableHandle tableHandle, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalPartsPerWorker") int totalPartsPerWorker, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalPartsPerWorker >= 1 ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be >= 1");
        Preconditions.checkState((totalPartsPerWorker > partNumber ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be > partNumber");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.partNumber = partNumber;
        this.totalPartsPerWorker = totalPartsPerWorker;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public MemoryTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public int getTotalPartsPerWorker() {
        return this.totalPartsPerWorker;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemorySplit other = (MemorySplit)obj;
        return Objects.equals(this.tableHandle, other.tableHandle) && Objects.equals(this.totalPartsPerWorker, other.totalPartsPerWorker) && Objects.equals(this.partNumber, other.partNumber);
    }

    public int hashCode() {
        return Objects.hash(this.tableHandle, this.totalPartsPerWorker, this.partNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("partNumber", this.partNumber).add("totalPartsPerWorker", this.totalPartsPerWorker).toString();
    }
}

