/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryConfig;
import com.facebook.presto.plugin.memory.MemoryErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class MemoryPagesStore {
    private final long maxBytes;
    @GuardedBy(value="this")
    private long currentBytes = 0L;
    private final Map<Long, List<Page>> pages = new HashMap<Long, List<Page>>();

    @Inject
    public MemoryPagesStore(MemoryConfig config) {
        this.maxBytes = config.getMaxDataPerNode().toBytes();
    }

    public synchronized void initialize(long tableId) {
        if (!this.pages.containsKey(tableId)) {
            this.pages.put(tableId, new ArrayList());
        }
    }

    public synchronized void add(Long tableId, Page page) {
        if (!this.contains(tableId)) {
            throw new PrestoException((ErrorCodeSupplier)MemoryErrorCode.MISSING_DATA, "Failed to find table on a worker.");
        }
        long newSize = this.currentBytes + page.getRetainedSizeInBytes();
        if (this.maxBytes < newSize) {
            throw new PrestoException((ErrorCodeSupplier)MemoryErrorCode.MEMORY_LIMIT_EXCEEDED, String.format("Memory limit [%d] for memory connector exceeded", this.maxBytes));
        }
        this.currentBytes = newSize;
        List<Page> tablePages = this.pages.get(tableId);
        tablePages.add(page);
    }

    public synchronized List<Page> getPages(Long tableId, int partNumber, int totalParts, List<Integer> columnIndexes) {
        if (!this.contains(tableId)) {
            throw new PrestoException((ErrorCodeSupplier)MemoryErrorCode.MISSING_DATA, "Failed to find table on a worker.");
        }
        List<Page> tablePages = this.pages.get(tableId);
        ImmutableList.Builder partitionedPages = ImmutableList.builder();
        for (int i = partNumber; i < tablePages.size(); i += totalParts) {
            partitionedPages.add((Object)MemoryPagesStore.getColumns(tablePages.get(i), columnIndexes));
        }
        return partitionedPages.build();
    }

    public synchronized boolean contains(Long tableId) {
        return this.pages.containsKey(tableId);
    }

    public synchronized void cleanUp(Set<Long> activeTableIds) {
        if (activeTableIds.isEmpty()) {
            return;
        }
        long latestTableId = Collections.max(activeTableIds);
        Iterator<Map.Entry<Long, List<Page>>> tablePages = this.pages.entrySet().iterator();
        while (tablePages.hasNext()) {
            Map.Entry<Long, List<Page>> tablePagesEntry = tablePages.next();
            Long tableId = tablePagesEntry.getKey();
            if (tableId >= latestTableId || activeTableIds.contains(tableId)) continue;
            for (Page removedPage : tablePagesEntry.getValue()) {
                this.currentBytes -= removedPage.getRetainedSizeInBytes();
            }
            tablePages.remove();
        }
    }

    private static Page getColumns(Page page, List<Integer> columnIndexes) {
        Block[] blocks = page.getBlocks();
        Block[] outputBlocks = new Block[columnIndexes.size()];
        for (int i = 0; i < columnIndexes.size(); ++i) {
            outputBlocks[i] = blocks[columnIndexes.get(i)];
        }
        return new Page(page.getPositionCount(), outputBlocks);
    }
}

