/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryColumnHandle;
import com.facebook.presto.plugin.memory.MemoryConnectorId;
import com.facebook.presto.plugin.memory.MemoryInsertTableHandle;
import com.facebook.presto.plugin.memory.MemoryOutputTableHandle;
import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.plugin.memory.MemoryTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class MemoryMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final NodeManager nodeManager;
    private final String connectorId;
    private final AtomicLong nextTableId = new AtomicLong();
    private final Map<String, Long> tableIds = new ConcurrentHashMap<String, Long>();
    private final Map<Long, MemoryTableHandle> tables = new ConcurrentHashMap<Long, MemoryTableHandle>();

    @Inject
    public MemoryMetadata(NodeManager nodeManager, MemoryConnectorId connectorId) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
    }

    public synchronized List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public synchronized ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Long tableId = this.tableIds.get(tableName.getTableName());
        if (tableId == null) {
            return null;
        }
        return this.tables.get(tableId);
    }

    public synchronized ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return memoryTableHandle.toTableMetadata();
    }

    public synchronized List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull != null && !schemaNameOrNull.equals(SCHEMA_NAME)) {
            return ImmutableList.of();
        }
        return this.tables.values().stream().map(MemoryTableHandle::toSchemaTableName).collect(Collectors.toList());
    }

    public synchronized Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return memoryTableHandle.getColumnHandles().stream().collect(Collectors.toMap(MemoryColumnHandle::getName, Function.identity()));
    }

    public synchronized ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        MemoryColumnHandle memoryColumnHandle = (MemoryColumnHandle)columnHandle;
        return memoryColumnHandle.toColumnMetadata();
    }

    public synchronized Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).collect(Collectors.toMap(MemoryTableHandle::toSchemaTableName, handle -> handle.toTableMetadata().getColumns()));
    }

    public synchronized void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        Long tableId = this.tableIds.remove(handle.getTableName());
        if (tableId != null) {
            this.tables.remove(tableId);
        }
    }

    public synchronized void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        MemoryTableHandle oldTableHandle = (MemoryTableHandle)tableHandle;
        MemoryTableHandle newTableHandle = new MemoryTableHandle(oldTableHandle.getConnectorId(), oldTableHandle.getSchemaName(), newTableName.getTableName(), oldTableHandle.getTableId(), oldTableHandle.getColumnHandles(), oldTableHandle.getHosts());
        this.tableIds.remove(oldTableHandle.getTableName());
        this.tableIds.put(newTableName.getTableName(), oldTableHandle.getTableId());
        this.tables.remove(oldTableHandle.getTableId());
        this.tables.put(oldTableHandle.getTableId(), newTableHandle);
    }

    public synchronized void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of());
    }

    public synchronized MemoryOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        long nextId = this.nextTableId.getAndIncrement();
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Memory nodes available");
        this.tableIds.put(tableMetadata.getTable().getTableName(), nextId);
        MemoryTableHandle table = new MemoryTableHandle(this.connectorId, nextId, tableMetadata, nodes.stream().map(Node::getHostAndPort).collect(Collectors.toList()));
        this.tables.put(table.getTableId(), table);
        return new MemoryOutputTableHandle(table, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    public synchronized Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        return Optional.empty();
    }

    public synchronized MemoryInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return new MemoryInsertTableHandle(memoryTableHandle, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    public synchronized Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        return Optional.empty();
    }

    public synchronized List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle handle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        Objects.requireNonNull(handle, "handle is null");
        Preconditions.checkArgument((boolean)(handle instanceof MemoryTableHandle));
        MemoryTableLayoutHandle layoutHandle = new MemoryTableLayoutHandle((MemoryTableHandle)handle);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, layoutHandle), constraint.getSummary()));
    }

    public synchronized ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle, Optional.empty(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }
}

