/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.MemoryReservationHandler;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

class RootAggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final MemoryReservationHandler reservationHandler;
    private final long guaranteedMemory;

    RootAggregatedMemoryContext(MemoryReservationHandler reservationHandler, long guaranteedMemory) {
        this.reservationHandler = Objects.requireNonNull(reservationHandler, "reservationHandler is null");
        this.guaranteedMemory = guaranteedMemory;
    }

    @Override
    synchronized ListenableFuture<?> updateBytes(String allocationTag, long bytes, boolean enforceBroadcastMemoryLimit) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"RootAggregatedMemoryContext is already closed");
        ListenableFuture future = this.reservationHandler.reserveMemory(allocationTag, bytes, enforceBroadcastMemoryLimit);
        this.addBytes(bytes);
        if (enforceBroadcastMemoryLimit) {
            this.addBroadcastBytes(bytes);
        }
        if (this.getBytes() < this.guaranteedMemory) {
            future = NOT_BLOCKED;
        }
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(String allocationTag, long delta, boolean enforceBroadcastMemoryLimit) {
        if (this.reservationHandler.tryReserveMemory(allocationTag, delta, enforceBroadcastMemoryLimit)) {
            this.addBytes(delta);
            if (enforceBroadcastMemoryLimit) {
                this.addBroadcastBytes(delta);
            }
            return true;
        }
        return false;
    }

    @Override
    synchronized AbstractAggregatedMemoryContext getParent() {
        return null;
    }

    @Override
    void closeContext() {
        this.reservationHandler.reserveMemory("FORCE_FREE_OPERATION", -this.getBytes(), false);
    }
}

