/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.ChildAggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractAggregatedMemoryContext
implements AggregatedMemoryContext {
    static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    public static final String FORCE_FREE_TAG = "FORCE_FREE_OPERATION";
    @GuardedBy(value="this")
    private long usedBytes;
    @GuardedBy(value="this")
    private boolean closed;

    @Override
    public AbstractAggregatedMemoryContext newAggregatedMemoryContext() {
        return new ChildAggregatedMemoryContext(this);
    }

    @Override
    public LocalMemoryContext newLocalMemoryContext(String allocationTag) {
        return new SimpleLocalMemoryContext(this, allocationTag);
    }

    @Override
    public synchronized long getBytes() {
        return this.usedBytes;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeContext();
        this.usedBytes = 0L;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.usedBytes).add("closed", this.closed).toString();
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void addBytes(long bytes) {
        this.usedBytes = AbstractAggregatedMemoryContext.addExact(this.usedBytes, bytes);
    }

    abstract ListenableFuture<?> updateBytes(String var1, long var2);

    abstract boolean tryUpdateBytes(String var1, long var2);

    @Nullable
    abstract AbstractAggregatedMemoryContext getParent();

    abstract void closeContext();

    static long addExact(long usedBytes, long bytes) {
        try {
            return Math.addExact(usedBytes, bytes);
        }
        catch (ArithmeticException e) {
            throw new RuntimeException(String.format("Overflow detected. usedBytes: %d, bytes: %d", usedBytes, bytes), e);
        }
    }
}

