/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SimpleLocalMemoryContext
implements LocalMemoryContext {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final AbstractAggregatedMemoryContext parentMemoryContext;
    private final String allocationTag;
    @GuardedBy(value="this")
    private long usedBytes;
    @GuardedBy(value="this")
    private boolean closed;

    public SimpleLocalMemoryContext(AggregatedMemoryContext parentMemoryContext, String allocationTag) {
        Verify.verify((boolean)(parentMemoryContext instanceof AbstractAggregatedMemoryContext));
        this.parentMemoryContext = (AbstractAggregatedMemoryContext)Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
        this.allocationTag = Objects.requireNonNull(allocationTag, "allocationTag is null");
    }

    @Override
    public synchronized long getBytes() {
        return this.usedBytes;
    }

    @Override
    public synchronized ListenableFuture<?> setBytes(long bytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"SimpleLocalMemoryContext is already closed");
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes cannot be negative");
        if (bytes == this.usedBytes) {
            return NOT_BLOCKED;
        }
        ListenableFuture<?> future = this.parentMemoryContext.updateBytes(this.allocationTag, bytes - this.usedBytes);
        this.usedBytes = bytes;
        return future;
    }

    @Override
    public synchronized boolean trySetBytes(long bytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"SimpleLocalMemoryContext is already closed");
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes cannot be negative");
        long delta = bytes - this.usedBytes;
        if (this.parentMemoryContext.tryUpdateBytes(this.allocationTag, delta)) {
            this.usedBytes = bytes;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.parentMemoryContext.updateBytes(this.allocationTag, -this.usedBytes);
        this.usedBytes = 0L;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allocationTag", (Object)this.allocationTag).add("usedBytes", this.usedBytes).toString();
    }
}

