/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.MemoryReservationHandler;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;

class RootAggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final MemoryReservationHandler reservationHandler;
    private final long guaranteedMemory;

    RootAggregatedMemoryContext(MemoryReservationHandler reservationHandler, long guaranteedMemory) {
        this.reservationHandler = Objects.requireNonNull(reservationHandler, "reservationHandler is null");
        this.guaranteedMemory = guaranteedMemory;
    }

    @Override
    synchronized ListenableFuture<?> updateBytes(Optional<String> allocationTag, long bytes) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"RootAggregatedMemoryContext is already closed");
        ListenableFuture future = this.reservationHandler.reserveMemory(allocationTag, bytes);
        this.addBytes(bytes);
        if (this.getBytes() < this.guaranteedMemory) {
            future = NOT_BLOCKED;
        }
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(Optional<String> allocationTag, long delta) {
        if (this.reservationHandler.tryReserveMemory(allocationTag, delta)) {
            this.addBytes(delta);
            return true;
        }
        return false;
    }

    @Override
    synchronized AbstractAggregatedMemoryContext getParent() {
        return null;
    }

    @Override
    void closeContext() {
        this.reservationHandler.reserveMemory(Optional.empty(), -this.getBytes());
    }
}

