/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.HiveFunctionHandleResolver;
import com.facebook.presto.hive.functions.HiveFunctionModule;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.function.FunctionHandleResolver;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerContext;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.llap.security.LlapSigner;

public class HiveFunctionNamespaceManagerFactory
implements FunctionNamespaceManagerFactory {
    private final ClassLoader classLoader;
    private final FunctionHandleResolver functionHandleResolver;
    public static final String NAME = "hive-functions";

    public HiveFunctionNamespaceManagerFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.functionHandleResolver = new HiveFunctionHandleResolver();
        try {
            Class<?> clazz = classLoader.loadClass(LlapSigner.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveFunctionErrorCode.HIVE_FUNCTION_INITIALIZATION_ERROR, (Throwable)e);
        }
    }

    public String getName() {
        return NAME;
    }

    public FunctionHandleResolver getHandleResolver() {
        return this.functionHandleResolver;
    }

    public FunctionNamespaceManager<?> create(String catalogName, Map<String, String> config, FunctionNamespaceManagerContext context) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new HiveFunctionModule(catalogName, this.classLoader, context.getTypeManager())});
            Injector injector = app.noStrictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).quiet().initialize();
            FunctionNamespaceManager functionNamespaceManager = (FunctionNamespaceManager)injector.getInstance(FunctionNamespaceManager.class);
            return functionNamespaceManager;
        }
    }
}

