/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.udf.grpc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.grpc.api.udf.GrpcUtils;
import com.facebook.presto.grpc.udf.GrpcSerializedPage;
import com.facebook.presto.grpc.udf.GrpcUdfInvokeGrpc;
import com.facebook.presto.grpc.udf.GrpcUdfPage;
import com.facebook.presto.grpc.udf.GrpcUdfPageFormat;
import com.facebook.presto.grpc.udf.GrpcUdfRequest;
import com.facebook.presto.grpc.udf.GrpcUdfResult;
import com.facebook.presto.grpc.udf.GrpcUdfStats;
import com.google.inject.Inject;
import io.grpc.stub.StreamObserver;

public class EchoFirstInputGrpcUdfService
extends GrpcUdfInvokeGrpc.GrpcUdfInvokeImplBase {
    private final BlockEncodingSerde blockEncodingSerde;

    @Inject
    public EchoFirstInputGrpcUdfService(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = blockEncodingSerde;
    }

    public void invokeUdf(GrpcUdfRequest request, StreamObserver<GrpcUdfResult> responseObserver) {
        GrpcUdfPage result;
        GrpcUdfPage grpcUdfPage = request.getInputs();
        switch (grpcUdfPage.getGrpcUdfPageFormat()) {
            case Presto: {
                Page prestoPage = GrpcUtils.toPrestoPage((BlockEncodingSerde)this.blockEncodingSerde, (GrpcSerializedPage)grpcUdfPage.getGrpcSerializedPage());
                if (prestoPage.getPositionCount() == 0) {
                    new UnsupportedOperationException("No input to echo");
                }
                GrpcSerializedPage grpcSerializedPage = GrpcUtils.toGrpcSerializedPage((BlockEncodingSerde)this.blockEncodingSerde, (Page)new Page(new Block[]{prestoPage.getBlock(0)}));
                result = GrpcUtils.toGrpcUdfPage((GrpcUdfPageFormat)GrpcUdfPageFormat.Presto, (GrpcSerializedPage)grpcSerializedPage);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        GrpcUdfResult grpcUdfResult = GrpcUdfResult.newBuilder().setResult(result).setUdfStats(GrpcUdfStats.newBuilder().setTotalCpuTimeMs(100L).build()).build();
        responseObserver.onNext((Object)grpcUdfResult);
        responseObserver.onCompleted();
    }
}

