/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import java.util.Objects;

public enum GeometryType {
    POINT(0, false),
    MULTI_POINT(1, true),
    LINE_STRING(2, false),
    MULTI_LINE_STRING(3, true),
    POLYGON(4, false),
    MULTI_POLYGON(5, true),
    GEOMETRY_COLLECTION(6, true),
    ENVELOPE(7, false);

    private final int code;
    private final boolean multitype;

    private GeometryType(int code, boolean multitype) {
        this.code = code;
        this.multitype = multitype;
    }

    public int code() {
        return this.code;
    }

    public boolean isMultitype() {
        return this.multitype;
    }

    public static GeometryType getForEsriGeometryType(String type) {
        return GeometryType.getForInternalLibraryName(type);
    }

    public static GeometryType getForJtsGeometryType(String type) {
        return GeometryType.getForInternalLibraryName(type);
    }

    private static GeometryType getForInternalLibraryName(String type) {
        Objects.requireNonNull(type, "type is null");
        switch (type) {
            case "Point": {
                return POINT;
            }
            case "MultiPoint": {
                return MULTI_POINT;
            }
            case "LineString": {
                return LINE_STRING;
            }
            case "MultiLineString": {
                return MULTI_LINE_STRING;
            }
            case "Polygon": {
                return POLYGON;
            }
            case "MultiPolygon": {
                return MULTI_POLYGON;
            }
            case "GeometryCollection": {
                return GEOMETRY_COLLECTION;
            }
        }
        throw new IllegalArgumentException("Invalid Geometry Type: " + type);
    }

    public static GeometryType getForCode(int code) {
        switch (code) {
            case 0: {
                return POINT;
            }
            case 1: {
                return MULTI_POINT;
            }
            case 2: {
                return LINE_STRING;
            }
            case 3: {
                return MULTI_LINE_STRING;
            }
            case 4: {
                return POLYGON;
            }
            case 5: {
                return MULTI_POLYGON;
            }
            case 6: {
                return GEOMETRY_COLLECTION;
            }
            case 7: {
                return ENVELOPE;
            }
        }
        throw new IllegalArgumentException("Invalid type code: " + code);
    }
}

