/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/functions")
public class FunctionResource {
    private final FunctionAndTypeManager manager;
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> jsonCodec;
    private final PagesSerde pagesSerde;
    private String etag = "\"etag\"";

    @Inject
    public FunctionResource(FunctionAndTypeManager manager, JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> jsonCodec) {
        this.manager = manager;
        this.jsonCodec = jsonCodec;
        this.pagesSerde = FunctionResource.createPagesSerde();
    }

    @GET
    @Produces(value={"application/json"})
    public String getFunctions() {
        HashMap udfMap = new HashMap();
        Collection builtInFunctions = this.manager.listBuiltInFunctions();
        for (SqlFunction function : builtInFunctions) {
            if (function.getSignature().getKind() != FunctionKind.SCALAR || function.getVisibility() == SqlFunctionVisibility.HIDDEN) continue;
            JsonBasedUdfFunctionMetadata metadata = FunctionResource.sqlFunctionToMetadata(function);
            String functionName = function.getSignature().getName().getObjectName();
            List<Object> functionList = new ArrayList<JsonBasedUdfFunctionMetadata>();
            if (udfMap.containsKey(functionName)) {
                functionList = (List)udfMap.get(functionName);
            }
            functionList.add(metadata);
            udfMap.put(functionName, functionList);
        }
        return this.jsonCodec.toJson(udfMap);
    }

    private static JsonBasedUdfFunctionMetadata sqlFunctionToMetadata(SqlFunction function) {
        return new JsonBasedUdfFunctionMetadata(function.getDescription() != null ? function.getDescription() : "", function.getSignature().getKind(), function.getSignature().getReturnType(), function.getSignature().getArgumentTypes(), function.getSignature().getName().getSchemaName(), function.getSignature().isVariableArity(), new RoutineCharacteristics(RoutineCharacteristics.Language.JAVA, function.isDeterministic() ? RoutineCharacteristics.Determinism.DETERMINISTIC : RoutineCharacteristics.Determinism.NOT_DETERMINISTIC, function.isCalledOnNullInput() ? RoutineCharacteristics.NullCallClause.CALLED_ON_NULL_INPUT : RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT), Optional.empty(), Optional.of(new SqlFunctionId(function.getSignature().getName(), function.getSignature().getArgumentTypes())), Optional.of("1"), Optional.of(function.getSignature().getTypeVariableConstraints()), Optional.ofNullable(function.getSignature().getLongVariableConstraints()), Optional.empty());
    }

    @GET
    @Path(value="/{schema}")
    @Produces(value={"application/json"})
    public String getFunctionsBySchema(@PathParam(value="schema") String schema) {
        HashMap udfMap = new HashMap();
        Collection builtInFunctions = this.manager.listBuiltInFunctions();
        for (SqlFunction function : builtInFunctions) {
            if (!function.getSignature().getName().getSchemaName().equals(schema) || function.getSignature().getKind() != FunctionKind.SCALAR || function.getVisibility() == SqlFunctionVisibility.HIDDEN) continue;
            String functionName = function.getSignature().getName().getObjectName();
            List<Object> functionList = new ArrayList<JsonBasedUdfFunctionMetadata>();
            if (udfMap.containsKey(functionName)) {
                functionList = (List)udfMap.get(functionName);
            }
            JsonBasedUdfFunctionMetadata metadata = FunctionResource.sqlFunctionToMetadata(function);
            functionList.add(metadata);
            udfMap.put(functionName, functionList);
        }
        return this.jsonCodec.toJson(udfMap);
    }

    @GET
    @Path(value="/{schema}/{functionName}")
    @Produces(value={"application/json"})
    public String getFunctionsBySchemaAndName(@PathParam(value="schema") String schema, @PathParam(value="functionName") String functionName) {
        HashMap udfMap = new HashMap();
        Collection functionList = this.manager.listBuiltInFunctions();
        ArrayList<JsonBasedUdfFunctionMetadata> filteredList = new ArrayList<JsonBasedUdfFunctionMetadata>();
        for (SqlFunction function : functionList) {
            if (function.getSignature().getKind() != FunctionKind.SCALAR || function.getVisibility() == SqlFunctionVisibility.HIDDEN || !function.getSignature().getName().getSchemaName().equals(schema) || !function.getSignature().getName().getObjectName().equals(functionName)) continue;
            filteredList.add(FunctionResource.sqlFunctionToMetadata(function));
        }
        if (!filteredList.isEmpty()) {
            udfMap.put(functionName, filteredList);
        }
        return this.jsonCodec.toJson(udfMap);
    }

    @POST
    @Path(value="/{schema}/{functionName}/{functionId}/{version}")
    @Consumes(value={"application/X-presto-pages"})
    @Produces(value={"application/X-presto-pages"})
    public byte[] execute(@PathParam(value="schema") String schema, @PathParam(value="functionName") String functionName, @PathParam(value="functionId") String functionId, @PathParam(value="version") String version, byte[] serializedPageByteArray) {
        Slice slice = Slices.wrappedBuffer((byte[])serializedPageByteArray);
        SerializedPage serializedPage = PagesSerdeUtil.readSerializedPage((SliceInput)new BasicSliceInput(slice));
        Page inputPage = this.pagesSerde.deserialize(serializedPage);
        List<TypeSignatureProvider> argumentTypeSignatures = FunctionResource.extractArgumentTypeSignatures(functionId);
        Type[] types = new Type[argumentTypeSignatures.size()];
        Block[] blocks = new Block[argumentTypeSignatures.size()];
        for (int i = 0; i < argumentTypeSignatures.size(); ++i) {
            types[i] = this.manager.getType(argumentTypeSignatures.get(i).getTypeSignature());
            blocks[i] = inputPage.getBlock(i);
        }
        FunctionHandle functionHandle = this.manager.lookupFunction(functionName, argumentTypeSignatures);
        BuiltInScalarFunctionImplementation functionImplementation = (BuiltInScalarFunctionImplementation)this.manager.getJavaScalarFunctionImplementation(functionHandle);
        int positionCount = inputPage.getPositionCount();
        int channelCount = inputPage.getChannelCount();
        Type returnType = this.manager.getType(this.manager.getFunctionMetadata(functionHandle).getReturnType());
        PageBuilder pageBuilder = new PageBuilder(Collections.singletonList(returnType));
        for (int position = 0; position < positionCount; ++position) {
            Object[] inputValues = new Object[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                inputValues[i] = blocks[i].isNull(position) ? null : this.deserializeBlock(types[i], blocks[i].getRegion(position, 1));
            }
            Object result = this.executeFunction(functionImplementation, inputValues);
            pageBuilder.declarePosition();
            BlockBuilder output = pageBuilder.getBlockBuilder(0);
            this.createResultBlock(output, returnType, result);
        }
        Page outputPage = pageBuilder.build();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput((int)outputPage.getRetainedSizeInBytes());
        PagesSerdeUtil.writeSerializedPage((SliceOutput)sliceOutput, (SerializedPage)this.pagesSerde.serialize(outputPage));
        return sliceOutput.slice().byteArray();
    }

    public static List<TypeSignatureProvider> extractArgumentTypeSignatures(String encodedFunctionId) {
        String functionId;
        try {
            functionId = URLDecoder.decode(encodedFunctionId, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Invalid functionId !");
        }
        SqlFunctionId sqlFunctionId = SqlFunctionId.parseSqlFunctionId((String)functionId);
        return sqlFunctionId.getArgumentTypes().stream().map(TypeSignatureProvider::new).collect(Collectors.toList());
    }

    private Object deserializeBlock(Type type, Block block) {
        if (block.isNull(0)) {
            return null;
        }
        switch (type.getTypeSignature().getBase()) {
            case "boolean": {
                return block.getByte(0) != 0;
            }
            case "integer": 
            case "bigint": 
            case "smallint": 
            case "tinyint": 
            case "real": 
            case "interval day to second": 
            case "interval year to month": 
            case "timestamp": 
            case "time": {
                return block.toLong(0);
            }
            case "double": {
                return Double.longBitsToDouble(block.toLong(0));
            }
            case "varchar": 
            case "varbinary": {
                return block.getSlice(0, 0, block.getSliceLength(0));
            }
        }
        throw new IllegalArgumentException("Unsupported type for deserialization: " + type);
    }

    private Object executeFunction(BuiltInScalarFunctionImplementation functionImplementation, Object[] arguments) {
        MethodHandle methodHandle = functionImplementation.getMethodHandle();
        try {
            return methodHandle.invokeWithArguments(arguments);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error during function execution", throwable);
        }
    }

    private static PagesSerde createPagesSerde() {
        return new PagesSerde((BlockEncodingSerde)new BlockEncodingManager(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private void createResultBlock(BlockBuilder output, Type type, Object result) {
        switch (type.getTypeSignature().getBase()) {
            case "integer": 
            case "bigint": 
            case "smallint": 
            case "tinyint": 
            case "real": 
            case "interval day to second": 
            case "interval year to month": 
            case "timestamp": 
            case "time": {
                type.writeLong(output, ((Long)result).longValue());
                break;
            }
            case "double": {
                type.writeDouble(output, ((Double)result).doubleValue());
                break;
            }
            case "boolean": {
                type.writeBoolean(output, ((Boolean)result).booleanValue());
                break;
            }
            case "varchar": 
            case "char": 
            case "json": 
            case "varbinary": {
                if (result instanceof Slice) {
                    type.writeSlice(output, (Slice)result);
                    break;
                }
                if (result instanceof byte[]) {
                    type.writeSlice(output, Slices.wrappedBuffer((byte[])((byte[])result)));
                    break;
                }
                type.writeSlice(output, Slices.utf8Slice((String)result.toString()));
                break;
            }
            case "decimal": {
                BigDecimal bd = (BigDecimal)result;
                type.writeSlice(output, Decimals.encodeScaledValue((BigDecimal)bd));
                break;
            }
            case "object": 
            case "array": 
            case "row": 
            case "map": {
                type.writeObject(output, result);
            }
        }
    }

    @HEAD
    public Response getFunctionHeaders() {
        return Response.ok().header("ETag", (Object)this.etag).build();
    }
}

