/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.TException;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.execution.thrift.ThriftSqlFunctionExecutionConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.ThriftScalarFunctionImplementation;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.udf.PrestoThriftPage;
import com.facebook.presto.thrift.api.udf.ThriftFunctionHandle;
import com.facebook.presto.thrift.api.udf.ThriftUdfPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfPageFormat;
import com.facebook.presto.thrift.api.udf.ThriftUdfResult;
import com.facebook.presto.thrift.api.udf.ThriftUdfService;
import com.facebook.presto.thrift.api.udf.ThriftUdfServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ThriftSqlFunctionExecutor {
    private final DriftClient<ThriftUdfService> thriftUdfClient;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Map<RoutineCharacteristics.Language, ThriftSqlFunctionExecutionConfig> executionConfigs;

    @Inject
    public ThriftSqlFunctionExecutor(DriftClient<ThriftUdfService> thriftUdfClient, BlockEncodingSerde blockEncodingSerde, Map<RoutineCharacteristics.Language, ThriftSqlFunctionExecutionConfig> executionConfigs) {
        this.thriftUdfClient = Objects.requireNonNull(thriftUdfClient, "thriftUdfClient is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.executionConfigs = Objects.requireNonNull(executionConfigs, "executionConfigs is null");
    }

    public CompletableFuture<Block> executeFunction(ThriftScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes, Type returnType) {
        ThriftUdfPage page = this.buildThriftPage(functionImplementation, input, channels, argumentTypes);
        SqlFunctionHandle functionHandle = functionImplementation.getFunctionHandle();
        SqlFunctionId functionId = functionHandle.getFunctionId();
        try {
            return MoreFutures.toCompletableFuture((ListenableFuture)((ThriftUdfService)this.thriftUdfClient.get(Optional.of(functionImplementation.getLanguage().getLanguage()))).invokeUdf(new ThriftFunctionHandle(functionId.getFunctionName().toString(), (List)functionId.getArgumentTypes().stream().map(TypeSignature::toString).collect(ImmutableList.toImmutableList()), returnType.toString(), functionHandle.getVersion()), page)).thenApply(result -> this.getResultBlock((ThriftUdfResult)result, returnType));
        }
        catch (TException | ThriftUdfServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
        }
    }

    private ThriftUdfPage buildThriftPage(ThriftScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes) {
        ThriftUdfPageFormat pageFormat = this.executionConfigs.get(functionImplementation.getLanguage()).getThriftPageFormat();
        Block[] blocks = new Block[channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            blocks[i] = input.getBlock(channels.get(i).intValue());
        }
        switch (pageFormat) {
            case PRESTO_THRIFT: {
                ImmutableList.Builder thriftBlocks = ImmutableList.builder();
                for (int i = 0; i < blocks.length; ++i) {
                    thriftBlocks.add((Object)PrestoThriftBlock.fromBlock((Block)blocks[i], (Type)argumentTypes.get(i)));
                }
                return ThriftUdfPage.thriftPage((PrestoThriftPage)new PrestoThriftPage((List)thriftBlocks.build(), input.getPositionCount()));
            }
            case PRESTO_SERIALIZED: {
                PagesSerde pagesSerde = new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
                return ThriftUdfPage.prestoPage((SerializedPage)pagesSerde.serialize(Page.wrapBlocksWithoutCopy((int)input.getPositionCount(), (Block[])blocks)));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown page format: %s", pageFormat));
    }

    private Block getResultBlock(ThriftUdfResult result, Type returnType) {
        ThriftUdfPage page = result.getResult();
        switch (page.getPageFormat()) {
            case PRESTO_THRIFT: {
                return ((PrestoThriftBlock)Iterables.getOnlyElement((Iterable)page.getThriftPage().getThriftBlocks())).toBlock(returnType);
            }
            case PRESTO_SERIALIZED: {
                PagesSerde pagesSerde = new PagesSerde(this.blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
                return pagesSerde.deserialize(page.getPrestoPage().toSerializedPage()).getBlock(0);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown page format: %s", page.getPageFormat()));
    }
}

