/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SqlInvokedFunctionNamespaceManagerConfig {
    private static final Splitter LANGUAGE_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private Duration functionCacheExpiration = new Duration(5.0, TimeUnit.MINUTES);
    private Duration functionInstanceCacheExpiration = new Duration(8.0, TimeUnit.HOURS);
    private Set<RoutineCharacteristics.Language> supportedFunctionLanguages = ImmutableSet.of((Object)RoutineCharacteristics.Language.SQL);

    @MinDuration(value="0ns")
    public Duration getFunctionCacheExpiration() {
        return this.functionCacheExpiration;
    }

    @Config(value="function-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionCacheExpiration(Duration functionCacheExpiration) {
        this.functionCacheExpiration = functionCacheExpiration;
        return this;
    }

    @MinDuration(value="0ns")
    public Duration getFunctionInstanceCacheExpiration() {
        return this.functionInstanceCacheExpiration;
    }

    @Config(value="function-instance-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionInstanceCacheExpiration(Duration functionInstanceCacheExpiration) {
        this.functionInstanceCacheExpiration = functionInstanceCacheExpiration;
        return this;
    }

    public Set<RoutineCharacteristics.Language> getSupportedFunctionLanguages() {
        return this.supportedFunctionLanguages;
    }

    @Config(value="supported-function-languages")
    public SqlInvokedFunctionNamespaceManagerConfig setSupportedFunctionLanguages(String languages) {
        ImmutableSet.Builder languageBuilder = ImmutableSet.builder();
        Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)languages).forEach(language -> languageBuilder.add((Object)new RoutineCharacteristics.Language(language)));
        this.supportedFunctionLanguages = languageBuilder.build();
        return this;
    }
}

