/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.presto.functionNamespace.mysql.DefineFunctionNamespacesTable;
import com.facebook.presto.functionNamespace.mysql.DefineSqlFunctionsTable;
import com.facebook.presto.functionNamespace.mysql.RoutineCharacteristicsArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.SqlFunctionIdArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecord;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecordRowMapper;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRowMapper;
import com.facebook.presto.functionNamespace.mysql.SqlParametersArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.TypeSignatureArgumentFactory;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.type.TypeSignature;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMappers;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterRowMappers(value={@RegisterRowMapper(value=SqlInvokedFunctionRowMapper.class), @RegisterRowMapper(value=SqlInvokedFunctionRecordRowMapper.class)})
@RegisterArgumentFactories(value={@RegisterArgumentFactory(value=SqlFunctionIdArgumentFactory.class), @RegisterArgumentFactory(value=SqlParametersArgumentFactory.class), @RegisterArgumentFactory(value=TypeSignatureArgumentFactory.class), @RegisterArgumentFactory(value=RoutineCharacteristicsArgumentFactory.class)})
@DefineFunctionNamespacesTable
@DefineSqlFunctionsTable
public interface FunctionNamespaceDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <function_namespaces_table> (\n   catalog_name varchar(128) NOT NULL,\n   schema_name varchar(128) NOT NULL,\n   PRIMARY KEY (catalog_name, schema_name))")
    public void createFunctionNamespacesTableIfNotExists();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <sql_functions_table> (\n  id bigint(20) NOT NULL AUTO_INCREMENT,\n  function_id varchar(700) NOT NULL,\n  version bigint(20) unsigned NOT NULL,\n  catalog_name varchar(128) NOT NULL,\n  schema_name varchar(128) NOT NULL,\n  function_name varchar(256) NOT NULL,\n  parameters varchar(40000) NOT NULL,\n  return_type varchar(256) NOT NULL,\n  routine_characteristics text NOT NULL,\n  body mediumtext,\n  description text,\n  deleted boolean NOT NULL DEFAULT false,\n  delete_time TIMESTAMP NULL DEFAULT NULL,\n  create_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n  update_time TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n  PRIMARY KEY (id),\n  UNIQUE KEY function_id_version (function_id, version),\n  KEY qualified_function_name (catalog_name, schema_name, function_name))")
    public void createSqlFunctionsTableIfNotExists();

    @SqlQuery(value="SELECT\n   count(1) > 0\nFROM <function_namespaces_table>\nWHERE catalog_name = :catalog_name\n  AND schema_name = :schema_name")
    public boolean functionNamespaceExists(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE catalog_name = :catalog_name\n    GROUP BY\n        function_id\n) v\n    ON t.function_id = v.function_id\n     AND t.version = v.version\nWHERE\n    NOT t.deleted")
    public List<SqlInvokedFunction> listFunctions(@Bind(value="catalog_name") String var1);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE catalog_name = :catalog_name\n      AND schema_name = :schema_name\n      AND function_name = :function_name\n    GROUP BY\n        function_id\n) v\n    ON t.function_id = v.function_id\n     AND t.version = v.version\nWHERE\n    NOT t.deleted")
    public List<SqlInvokedFunction> getFunctions(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="function_name") String var3);

    @SqlQuery(value="SELECT\n    catalog_name,\n    schema_name,\n    function_name,\n    parameters,\n    return_type,\n    description,\n    routine_characteristics,\n    body,\n    version\nFROM <sql_functions_table>\nWHERE\n    function_id = :function_id\n    AND version = :version")
    public Optional<SqlInvokedFunction> getFunction(@Bind(value="function_id") SqlFunctionId var1, @Bind(value="version") long var2);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version,\n    t.deleted\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE\n        function_id = :function_id\n) v\nON\n    t.version = v.version\nWHERE\n    t.function_id = :function_id\nFOR UPDATE")
    public Optional<SqlInvokedFunctionRecord> getLatestRecordForUpdate(@Bind(value="function_id") SqlFunctionId var1);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version,\n    t.deleted\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE\n        catalog_name = :catalog_name\n        AND schema_name = :schema_name\n        AND function_name = :function_name\n    GROUP BY\n        function_id\n) v\nON\n    t.function_id = v.function_id\n    AND t.version = v.version\nFOR UPDATE")
    public List<SqlInvokedFunctionRecord> getLatestRecordsForUpdate(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="function_name") String var3);

    @SqlUpdate(value="INSERT INTO <sql_functions_table> (\n        function_id,\n        version,\n        catalog_name,\n        schema_name,\n        function_name,\n        parameters,\n        return_type,\n        description,\n        routine_characteristics,\n        body\n    )\nVALUES\n    (\n        :function_id,\n        :version,\n        :catalog_name,\n        :schema_name,\n        :function_name,\n        :parameters,\n        :return_type,\n        :description,\n        :routine_characteristics,\n        :body\n    )")
    public void insertFunction(@Bind(value="function_id") SqlFunctionId var1, @Bind(value="version") long var2, @Bind(value="catalog_name") String var4, @Bind(value="schema_name") String var5, @Bind(value="function_name") String var6, @Bind(value="parameters") List<SqlParameter> var7, @Bind(value="return_type") TypeSignature var8, @Bind(value="description") String var9, @Bind(value="routine_characteristics") RoutineCharacteristics var10, @Bind(value="body") String var11);

    @SqlUpdate(value="UPDATE\n    <sql_functions_table>\nSET\n    deleted = :deleted\n,    delete_time = IF(:deleted, NOW(), null)\nWHERE\n    function_id = :function_id\n    AND version = :version")
    public int setDeletionStatus(@Bind(value="function_id") SqlFunctionId var1, @Bind(value="version") long var2, @Bind(value="deleted") boolean var4);
}

