/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace;

import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.UuidFunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.function.SqlParameter;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractSqlInvokedFunctionNamespaceManager
implements FunctionNamespaceManager<SqlInvokedFunction> {
    private final ConcurrentMap<FunctionNamespaceTransactionHandle, FunctionCollection> transactions = new ConcurrentHashMap<FunctionNamespaceTransactionHandle, FunctionCollection>();
    private final String catalogName;
    private final LoadingCache<QualifiedFunctionName, Collection<SqlInvokedFunction>> functions;
    private final LoadingCache<SqlFunctionHandle, FunctionMetadata> metadataByHandle;
    private final LoadingCache<SqlFunctionHandle, ScalarFunctionImplementation> implementationByHandle;

    public AbstractSqlInvokedFunctionNamespaceManager(String catalogName, SqlInvokedFunctionNamespaceManagerConfig config) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.functions = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<QualifiedFunctionName, Collection<SqlInvokedFunction>>(){

            @ParametersAreNonnullByDefault
            public Collection<SqlInvokedFunction> load(QualifiedFunctionName functionName) {
                Collection<SqlInvokedFunction> functions = AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionsDirect(functionName);
                for (SqlInvokedFunction function : functions) {
                    AbstractSqlInvokedFunctionNamespaceManager.this.metadataByHandle.put((Object)function.getRequiredFunctionHandle(), (Object)AbstractSqlInvokedFunctionNamespaceManager.sqlInvokedFunctionToMetadata(function));
                }
                return functions;
            }
        });
        this.metadataByHandle = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionInstanceCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SqlFunctionHandle, FunctionMetadata>(){

            @ParametersAreNonnullByDefault
            public FunctionMetadata load(SqlFunctionHandle functionHandle) {
                return AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionMetadataDirect(functionHandle);
            }
        });
        this.implementationByHandle = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionInstanceCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SqlFunctionHandle, ScalarFunctionImplementation>(){

            public ScalarFunctionImplementation load(SqlFunctionHandle functionHandle) {
                return AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionImplementationDirect(functionHandle);
            }
        });
    }

    protected abstract Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedFunctionName var1);

    protected abstract FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle var1);

    protected abstract ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle var1);

    public final FunctionNamespaceTransactionHandle beginTransaction() {
        UuidFunctionNamespaceTransactionHandle transactionHandle = UuidFunctionNamespaceTransactionHandle.create();
        this.transactions.put(transactionHandle, new FunctionCollection());
        return transactionHandle;
    }

    public final void commit(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final void abort(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final Collection<SqlInvokedFunction> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedFunctionName functionName) {
        this.checkCatalog(functionName);
        Preconditions.checkArgument((boolean)transactionHandle.isPresent(), (Object)"missing transactionHandle");
        return ((FunctionCollection)this.transactions.get(transactionHandle.get())).loadAndGetFunctionsTransactional(functionName);
    }

    public final FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        this.checkCatalog(signature.getName());
        Preconditions.checkArgument((boolean)transactionHandle.isPresent(), (Object)"missing transactionHandle");
        SqlFunctionId functionId = new SqlFunctionId(signature.getName(), signature.getArgumentTypes());
        return ((FunctionCollection)this.transactions.get(transactionHandle.get())).getFunctionHandle(functionId);
    }

    public final FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        return (FunctionMetadata)this.metadataByHandle.getUnchecked((Object)((SqlFunctionHandle)functionHandle));
    }

    public final ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle);
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        return (ScalarFunctionImplementation)this.implementationByHandle.getUnchecked((Object)((SqlFunctionHandle)functionHandle));
    }

    protected String getCatalogName() {
        return this.catalogName;
    }

    protected void checkCatalog(SqlFunction function) {
        this.checkCatalog(function.getSignature().getName());
    }

    protected void checkCatalog(QualifiedFunctionName functionName) {
        this.checkCatalog(functionName.getFunctionNamespace());
    }

    protected void checkCatalog(FunctionHandle functionHandle) {
        this.checkCatalog(functionHandle.getFunctionNamespace());
    }

    protected void checkCatalog(CatalogSchemaName functionNamespace) {
        Preconditions.checkArgument((boolean)this.catalogName.equals(functionNamespace.getCatalogName()), (String)"Catalog [%s] is not served by this FunctionNamespaceManager, expected: %s", (Object)functionNamespace.getCatalogName(), (Object)this.catalogName);
    }

    protected void refreshFunctionsCache(QualifiedFunctionName functionName) {
        this.functions.refresh((Object)functionName);
    }

    protected static FunctionMetadata sqlInvokedFunctionToMetadata(SqlInvokedFunction function) {
        return new FunctionMetadata(function.getSignature().getName(), function.getSignature().getArgumentTypes(), (List)function.getParameters().stream().map(SqlParameter::getName).collect(ImmutableList.toImmutableList()), function.getSignature().getReturnType(), FunctionKind.SCALAR, function.getFunctionImplementationType(), function.isDeterministic(), function.isCalledOnNullInput());
    }

    protected static ScalarFunctionImplementation sqlInvokedFunctionToImplementation(SqlInvokedFunction function) {
        Preconditions.checkArgument((boolean)function.getFunctionImplementationType().equals((Object)FunctionImplementationType.SQL));
        return new SqlInvokedScalarFunctionImplementation(function.getBody());
    }

    private Collection<SqlInvokedFunction> fetchFunctions(QualifiedFunctionName functionName) {
        return (Collection)this.functions.getUnchecked((Object)functionName);
    }

    private class FunctionCollection {
        @GuardedBy(value="this")
        private final Map<QualifiedFunctionName, Collection<SqlInvokedFunction>> functions = new ConcurrentHashMap<QualifiedFunctionName, Collection<SqlInvokedFunction>>();
        @GuardedBy(value="this")
        private final Map<SqlFunctionId, SqlFunctionHandle> functionHandles = new ConcurrentHashMap<SqlFunctionId, SqlFunctionHandle>();

        private FunctionCollection() {
        }

        public synchronized Collection<SqlInvokedFunction> loadAndGetFunctionsTransactional(QualifiedFunctionName functionName) {
            Collection functions = this.functions.computeIfAbsent(functionName, x$0 -> AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctions(x$0));
            this.functionHandles.putAll((Map)functions.stream().collect(ImmutableMap.toImmutableMap(SqlInvokedFunction::getFunctionId, SqlInvokedFunction::getRequiredFunctionHandle)));
            return functions;
        }

        public synchronized FunctionHandle getFunctionHandle(SqlFunctionId functionId) {
            return (FunctionHandle)this.functionHandles.get(functionId);
        }
    }
}

