/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class ExampleHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public ExampleHandleResolver(ExampleConnectorId clientId) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null")).toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof ExampleTableHandle && ((ExampleTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof ExampleColumnHandle && ((ExampleColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof ExampleSplit && ((ExampleSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return false;
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return ExampleTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return ExampleColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return ExampleSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }
}

