/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleConnector;
import com.facebook.presto.example.ExampleModule;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;

public class ExampleConnectorFactory
implements ConnectorFactory {
    private final Map<String, String> optionalConfig;

    public ExampleConnectorFactory(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null")));
    }

    public String getName() {
        return "example-http";
    }

    public Connector create(String connectorId, Map<String, String> requiredConfig) {
        Preconditions.checkNotNull(requiredConfig, (Object)"requiredConfig is null");
        Preconditions.checkNotNull(this.optionalConfig, (Object)"optionalConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new ExampleModule(connectorId)});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(ExampleConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

