/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.example.ExampleTableLayoutHandle;
import com.facebook.presto.example.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ExampleMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleMetadata(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.exampleClient = Objects.requireNonNull(exampleClient, "client is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        return ImmutableList.copyOf(this.exampleClient.getSchemaNames());
    }

    public ExampleTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ExampleTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ExampleTableHandle tableHandle = Types.checkType(table, ExampleTableHandle.class, "table");
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new ExampleTableLayoutHandle(tableHandle));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        ExampleTableHandle exampleTableHandle = Types.checkType(table, ExampleTableHandle.class, "table");
        Preconditions.checkArgument((boolean)exampleTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        SchemaTableName tableName = new SchemaTableName(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        Object schemaNames = schemaNameOrNull != null ? ImmutableSet.of((Object)schemaNameOrNull) : this.exampleClient.getSchemaNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator iterator = schemaNames.iterator();
        while (iterator.hasNext()) {
            String schemaName = (String)iterator.next();
            for (String tableName : this.exampleClient.getTableNames(schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ExampleTableHandle exampleTableHandle = Types.checkType(tableHandle, ExampleTableHandle.class, "tableHandle");
        Preconditions.checkArgument((boolean)exampleTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(exampleTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new ExampleColumnHandle(this.connectorId, column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        ExampleTable table = this.exampleClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, ExampleTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, ExampleColumnHandle.class, "columnHandle").getColumnMetadata();
    }
}

