/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleHandleResolver;
import com.facebook.presto.example.ExampleMetadata;
import com.facebook.presto.example.ExampleRecordSetProvider;
import com.facebook.presto.example.ExampleSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleConnector
implements Connector {
    private static final Logger log = Logger.get(ExampleConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ExampleMetadata metadata;
    private final ExampleSplitManager splitManager;
    private final ExampleRecordSetProvider recordSetProvider;
    private final ExampleHandleResolver handleResolver;

    @Inject
    public ExampleConnector(LifeCycleManager lifeCycleManager, ExampleMetadata metadata, ExampleSplitManager splitManager, ExampleRecordSetProvider recordSetProvider, ExampleHandleResolver handleResolver) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return this.handleResolver;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

