/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.example.ExampleTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class ExampleHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public ExampleHandleResolver(ExampleConnectorId clientId) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null")).toString();
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof ExampleTableHandle && ((ExampleTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof ExampleColumnHandle && ((ExampleColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof ExampleSplit && ((ExampleSplit)split).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorTableLayoutHandle handle) {
        return handle instanceof ExampleTableLayoutHandle;
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass() {
        return ExampleTableLayoutHandle.class;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return ExampleTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return ExampleColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return ExampleSplit.class;
    }
}

