/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExamplePartition;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.example.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.exampleClient = (ExampleClient)Preconditions.checkNotNull((Object)exampleClient, (Object)"client is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        ExampleTableHandle exampleTableHandle = Types.checkType(tableHandle, ExampleTableHandle.class, "tableHandle");
        ImmutableList partitions = ImmutableList.of((Object)new ExamplePartition(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        Preconditions.checkArgument((partitions.size() == 1 ? 1 : 0) != 0, (String)"Expected one partition but got %s", (Object[])new Object[]{partitions.size()});
        ConnectorPartition partition = partitions.get(0);
        ExamplePartition examplePartition = Types.checkType(partition, ExamplePartition.class, "partition");
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        Preconditions.checkState((table != null ? 1 : 0) != 0, (String)"Table %s.%s no longer exists", (Object[])new Object[]{exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()});
        ArrayList<ExampleSplit> splits = new ArrayList<ExampleSplit>();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(this.connectorId, examplePartition.getSchemaName(), examplePartition.getTableName(), uri));
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(this.connectorId, splits);
    }
}

