/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClientTypeSignature {
    private static final Pattern PATTERN = Pattern.compile(".*[<>,].*");
    private final String rawType;
    private final List<ClientTypeSignature> typeArguments;
    private final List<Object> literalArguments;

    public ClientTypeSignature(TypeSignature typeSignature) {
        this(typeSignature.getBase(), Lists.transform((List)typeSignature.getParameters(), ClientTypeSignature::new), typeSignature.getLiteralParameters());
    }

    @JsonCreator
    public ClientTypeSignature(@JsonProperty(value="rawType") String rawType, @JsonProperty(value="typeArguments") List<ClientTypeSignature> typeArguments, @JsonProperty(value="literalArguments") List<Object> literalArguments) {
        Preconditions.checkArgument((rawType != null ? 1 : 0) != 0, (Object)"rawType is null");
        this.rawType = rawType;
        Preconditions.checkArgument((!rawType.isEmpty() ? 1 : 0) != 0, (Object)"rawType is empty");
        Preconditions.checkArgument((!PATTERN.matcher(rawType).matches() ? 1 : 0) != 0, (String)"Bad characters in rawType type: %s", (Object[])new Object[]{rawType});
        Preconditions.checkArgument((typeArguments != null ? 1 : 0) != 0, (Object)"typeArguments is null");
        Preconditions.checkArgument((literalArguments != null ? 1 : 0) != 0, (Object)"literalArguments is null");
        for (Object literal : literalArguments) {
            Preconditions.checkArgument((literal instanceof String || literal instanceof Long ? 1 : 0) != 0, (String)"Unsupported literal type: %s", (Object[])new Object[]{literal.getClass()});
        }
        this.typeArguments = Collections.unmodifiableList(new ArrayList<ClientTypeSignature>(typeArguments));
        this.literalArguments = Collections.unmodifiableList(new ArrayList<Object>(literalArguments));
    }

    @JsonProperty
    public String getRawType() {
        return this.rawType;
    }

    @JsonProperty
    public List<ClientTypeSignature> getTypeArguments() {
        return this.typeArguments;
    }

    @JsonProperty
    public List<Object> getLiteralArguments() {
        return this.literalArguments;
    }

    public String toString() {
        boolean first;
        StringBuilder typeName = new StringBuilder(this.rawType);
        if (!this.typeArguments.isEmpty()) {
            typeName.append("<");
            first = true;
            for (ClientTypeSignature argument : this.typeArguments) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                typeName.append(argument.toString());
            }
            typeName.append(">");
        }
        if (!this.literalArguments.isEmpty()) {
            typeName.append("(");
            first = true;
            for (Object parameter : this.literalArguments) {
                if (!first) {
                    typeName.append(",");
                }
                first = false;
                if (parameter instanceof String) {
                    typeName.append("'").append(parameter).append("'");
                    continue;
                }
                typeName.append(parameter.toString());
            }
            typeName.append(")");
        }
        return typeName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignature other = (ClientTypeSignature)o;
        return Objects.equals(this.rawType.toLowerCase(Locale.ENGLISH), other.rawType.toLowerCase(Locale.ENGLISH)) && Objects.equals(this.typeArguments, other.typeArguments) && Objects.equals(this.literalArguments, other.literalArguments);
    }

    public int hashCode() {
        return Objects.hash(this.rawType.toLowerCase(Locale.ENGLISH), this.typeArguments, this.literalArguments);
    }
}

