/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.json.JsonCodec;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StatementClient
implements Closeable {
    private static final String USER_AGENT_VALUE = StatementClient.class.getSimpleName() + "/" + (String)Objects.firstNonNull((Object)StatementClient.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final AsyncHttpClient httpClient;
    private final FullJsonResponseHandler<QueryResults> responseHandler;
    private final boolean debug;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean gone = new AtomicBoolean();
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public StatementClient(AsyncHttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec, ClientSession session, String query) {
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.httpClient = httpClient;
        this.responseHandler = FullJsonResponseHandler.createFullJsonResponseHandler(queryResultsCodec);
        this.debug = session.isDebug();
        this.query = query;
        Request request = StatementClient.buildQueryRequest(session, query);
        this.currentResults.set((QueryResults)((FullJsonResponseHandler.JsonResponse)httpClient.execute(request, this.responseHandler)).getValue());
    }

    private static Request buildQueryRequest(ClientSession session, String query) {
        Request.Builder builder = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)session.getServer()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)Charsets.UTF_8));
        if (session.getUser() != null) {
            builder.setHeader("X-Presto-User", session.getUser());
        }
        if (session.getSource() != null) {
            builder.setHeader("X-Presto-Source", session.getSource());
        }
        if (session.getCatalog() != null) {
            builder.setHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.setHeader("X-Presto-Schema", session.getSchema());
        }
        builder.setHeader("User-Agent", USER_AGENT_VALUE);
        return builder.build();
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isGone() {
        return this.gone.get();
    }

    public boolean isFailed() {
        return this.currentResults.get().getError() != null;
    }

    public QueryResults current() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    public QueryResults finalResults() {
        Preconditions.checkState((!this.isValid() || this.isFailed() ? 1 : 0) != 0, (Object)"current position is still valid");
        return this.currentResults.get();
    }

    public boolean isValid() {
        return this.valid.get() && !this.isGone() && !this.isClosed();
    }

    public boolean advance() {
        if (this.isClosed() || this.current().getNextUri() == null) {
            this.valid.set(false);
            return false;
        }
        Request request = Request.Builder.prepareGet().setHeader("User-Agent", USER_AGENT_VALUE).setUri(this.current().getNextUri()).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        do {
            FullJsonResponseHandler.JsonResponse response;
            if (attempts > 0L) {
                Uninterruptibles.sleepUninterruptibly((long)(attempts * 100L), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            ++attempts;
            try {
                response = (FullJsonResponseHandler.JsonResponse)this.httpClient.execute(request, this.responseHandler);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.currentResults.set((QueryResults)response.getValue());
                return true;
            }
            if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) continue;
            this.gone.set(true);
            throw new RuntimeException(String.format("Error fetching next at %s returned %s: %s", request.getUri(), response.getStatusCode(), response.getStatusMessage()));
        } while (System.nanoTime() - start < TimeUnit.MINUTES.toNanos(2L) && !this.isClosed());
        this.gone.set(true);
        throw new RuntimeException("Error fetching next", cause);
    }

    public boolean cancelLeafStage() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"client is closed");
        URI uri = this.current().getPartialCancelUri();
        if (uri == null) {
            return false;
        }
        Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
        StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        return HttpStatus.familyForStatusCode((int)status.getStatusCode()) == HttpStatus.Family.SUCCESSFUL;
    }

    @Override
    public void close() {
        URI uri;
        if (!this.closed.getAndSet(true) && (uri = this.currentResults.get().getNextUri()) != null) {
            Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
            this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        }
    }
}

