/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.JsonResponse;
import com.facebook.presto.client.OkHttpUtil;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.spi.security.SelectedRole;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

@ThreadSafe
class StatementClientV1
implements StatementClient {
    private static final MediaType MEDIA_TYPE_TEXT = MediaType.parse((String)"text/plain; charset=utf-8");
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private static final Splitter SESSION_HEADER_SPLITTER = Splitter.on((char)'=').limit(2).trimResults();
    private static final String USER_AGENT_VALUE = StatementClientV1.class.getSimpleName() + "/" + (String)MoreObjects.firstNonNull((Object)StatementClientV1.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final OkHttpClient httpClient;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, SelectedRole> setRoles = new ConcurrentHashMap<String, SelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<String> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final TimeZoneKey timeZone;
    private final Duration requestTimeoutNanos;
    private final String user;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);

    public StatementClientV1(OkHttpClient httpClient, ClientSession session, String query) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        this.httpClient = httpClient;
        this.timeZone = session.getTimeZone();
        this.query = query;
        this.requestTimeoutNanos = session.getClientRequestTimeout();
        this.user = session.getUser();
        Request request = this.buildQueryRequest(session, query);
        JsonResponse<QueryResults> response = JsonResponse.execute(QUERY_RESULTS_CODEC, httpClient, request);
        if (response.getStatusCode() != 200 || !response.hasValue()) {
            this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
            throw this.requestFailedException("starting query", request, response);
        }
        this.processResponse(response.getHeaders(), response.getValue());
    }

    private Request buildQueryRequest(ClientSession session, String query) {
        HttpUrl url = HttpUrl.get((URI)session.getServer());
        if (url == null) {
            throw new ClientException("Invalid server URL: " + session.getServer());
        }
        url = url.newBuilder().encodedPath("/v1/statement").build();
        Request.Builder builder = this.prepareRequest(url).post(RequestBody.create((MediaType)MEDIA_TYPE_TEXT, (String)query));
        if (session.getSource() != null) {
            builder.addHeader("X-Presto-Source", session.getSource());
        }
        session.getTraceToken().ifPresent(token -> builder.addHeader("X-Presto-Trace-Token", token));
        if (session.getClientTags() != null && !session.getClientTags().isEmpty()) {
            builder.addHeader("X-Presto-Client-Tags", Joiner.on((String)",").join(session.getClientTags()));
        }
        if (session.getClientInfo() != null) {
            builder.addHeader("X-Presto-Client-Info", session.getClientInfo());
        }
        if (session.getCatalog() != null) {
            builder.addHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.addHeader("X-Presto-Schema", session.getSchema());
        }
        builder.addHeader("X-Presto-Time-Zone", session.getTimeZone().getId());
        if (session.getLocale() != null) {
            builder.addHeader("X-Presto-Language", session.getLocale().toLanguageTag());
        }
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader("X-Presto-Session", entry.getKey() + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        Map<String, String> resourceEstimates = session.getResourceEstimates();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            builder.addHeader("X-Presto-Resource-Estimate", entry.getKey() + "=" + entry.getValue());
        }
        Map<String, SelectedRole> map = session.getRoles();
        for (Map.Entry<String, SelectedRole> entry : map.entrySet()) {
            builder.addHeader("X-Presto-Role", entry.getKey() + '=' + StatementClientV1.urlEncode(entry.getValue().toString()));
        }
        Map<String, String> map2 = session.getExtraCredentials();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            builder.addHeader("X-Presto-Extra-Credential", entry.getKey() + "=" + entry.getValue());
        }
        Map<String, String> map3 = session.getPreparedStatements();
        for (Map.Entry<String, String> entry : map3.entrySet()) {
            builder.addHeader("X-Presto-Prepared-Statement", StatementClientV1.urlEncode(entry.getKey()) + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        builder.addHeader("X-Presto-Transaction-Id", session.getTransactionId() == null ? "NONE" : session.getTransactionId());
        return builder.build();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public TimeZoneKey getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    @Override
    public boolean isClientAborted() {
        return this.state.get() == State.CLIENT_ABORTED;
    }

    @Override
    public boolean isClientError() {
        return this.state.get() == State.CLIENT_ERROR;
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == State.FINISHED;
    }

    @Override
    public StatementStats getStats() {
        return this.currentResults.get().getStats();
    }

    @Override
    public QueryStatusInfo currentStatusInfo() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    @Override
    public QueryData currentData() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    @Override
    public QueryStatusInfo finalStatusInfo() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0, (Object)"current position is still valid");
        return this.currentResults.get();
    }

    @Override
    public Optional<String> getSetCatalog() {
        return Optional.ofNullable(this.setCatalog.get());
    }

    @Override
    public Optional<String> getSetSchema() {
        return Optional.ofNullable(this.setSchema.get());
    }

    @Override
    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    @Override
    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    @Override
    public Map<String, SelectedRole> getSetRoles() {
        return ImmutableMap.copyOf(this.setRoles);
    }

    @Override
    public Map<String, String> getAddedPreparedStatements() {
        return ImmutableMap.copyOf(this.addedPreparedStatements);
    }

    @Override
    public Set<String> getDeallocatedPreparedStatements() {
        return ImmutableSet.copyOf(this.deallocatedPreparedStatements);
    }

    @Override
    @Nullable
    public String getStartedTransactionId() {
        return this.startedTransactionId.get();
    }

    @Override
    public boolean isClearTransactionId() {
        return this.clearTransactionId.get();
    }

    private Request.Builder prepareRequest(HttpUrl url) {
        return new Request.Builder().addHeader("X-Presto-User", this.user).addHeader("User-Agent", USER_AGENT_VALUE).url(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advance() {
        JsonResponse<QueryResults> response;
        if (!this.isRunning()) {
            return false;
        }
        URI nextUri = this.currentStatusInfo().getNextUri();
        if (nextUri == null) {
            this.state.compareAndSet(State.RUNNING, State.FINISHED);
            return false;
        }
        Request request = this.prepareRequest(HttpUrl.get((URI)nextUri)).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        while (true) {
            if (this.isClientAborted()) {
                return false;
            }
            Duration sinceStart = Duration.nanosSince((long)start);
            if (attempts > 0L && sinceStart.compareTo(this.requestTimeoutNanos) > 0) {
                this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                throw new RuntimeException(String.format("Error fetching next (attempts: %s, duration: %s)", attempts, sinceStart), cause);
            }
            if (attempts > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                }
                catch (InterruptedException e) {
                    try {
                        this.close();
                    }
                    finally {
                        Thread.currentThread().interrupt();
                    }
                    this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                    throw new RuntimeException("StatementClient thread was interrupted");
                }
            }
            ++attempts;
            try {
                response = JsonResponse.execute(QUERY_RESULTS_CODEC, this.httpClient, request);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == 200 && response.hasValue()) {
                this.processResponse(response.getHeaders(), response.getValue());
                return true;
            }
            if (response.getStatusCode() != 503) break;
        }
        this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
        throw this.requestFailedException("fetching next", request, response);
    }

    private void processResponse(Headers headers, QueryResults results) {
        List keyValue;
        this.setCatalog.set(headers.get("X-Presto-Set-Catalog"));
        this.setSchema.set(headers.get("X-Presto-Set-Schema"));
        for (String setSession : headers.values("X-Presto-Set-Session")) {
            keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setSession);
            if (keyValue.size() != 2) continue;
            this.setSessionProperties.put((String)keyValue.get(0), StatementClientV1.urlDecode((String)keyValue.get(1)));
        }
        this.resetSessionProperties.addAll(headers.values("X-Presto-Clear-Session"));
        for (String setRole : headers.values("X-Presto-Set-Role")) {
            keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setRole);
            if (keyValue.size() != 2) continue;
            this.setRoles.put((String)keyValue.get(0), SelectedRole.valueOf((String)StatementClientV1.urlDecode((String)keyValue.get(1))));
        }
        for (String entry : headers.values("X-Presto-Added-Prepare")) {
            keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)entry);
            if (keyValue.size() != 2) continue;
            this.addedPreparedStatements.put(StatementClientV1.urlDecode((String)keyValue.get(0)), StatementClientV1.urlDecode((String)keyValue.get(1)));
        }
        for (String entry : headers.values("X-Presto-Deallocated-Prepare")) {
            this.deallocatedPreparedStatements.add(StatementClientV1.urlDecode(entry));
        }
        String startedTransactionId = headers.get("X-Presto-Started-Transaction-Id");
        if (startedTransactionId != null) {
            this.startedTransactionId.set(startedTransactionId);
        }
        if (headers.get("X-Presto-Clear-Transaction-Id") != null) {
            this.clearTransactionId.set(true);
        }
        this.currentResults.set(results);
    }

    private RuntimeException requestFailedException(String task, Request request, JsonResponse<QueryResults> response) {
        if (!response.hasValue()) {
            if (response.getStatusCode() == 401) {
                return new ClientException("Authentication failed" + Optional.ofNullable(response.getStatusMessage()).map(message -> ": " + message).orElse(""));
            }
            return new RuntimeException(String.format("Error %s at %s returned an invalid response: %s [Error: %s]", task, request.url(), response, response.getResponseBody()), response.getException());
        }
        return new RuntimeException(String.format("Error %s at %s returned HTTP %s", task, request.url(), response.getStatusCode()));
    }

    @Override
    public void cancelLeafStage() {
        Preconditions.checkState((!this.isClientAborted() ? 1 : 0) != 0, (Object)"client is closed");
        URI uri = this.currentStatusInfo().getPartialCancelUri();
        if (uri != null) {
            this.httpDelete(uri);
        }
    }

    @Override
    public void close() {
        URI uri;
        if (this.state.compareAndSet(State.RUNNING, State.CLIENT_ABORTED) && (uri = this.currentResults.get().getNextUri()) != null) {
            this.httpDelete(uri);
        }
    }

    private void httpDelete(URI uri) {
        Request request = this.prepareRequest(HttpUrl.get((URI)uri)).delete().build();
        this.httpClient.newCall(request).enqueue((Callback)new OkHttpUtil.NullCallback());
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static enum State {
        RUNNING,
        CLIENT_ERROR,
        CLIENT_ABORTED,
        FINISHED;

    }
}

