/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QueryResults
implements QueryStatusInfo,
QueryData {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final Iterable<List<Object>> data;
    private final StatementStats stats;
    private final QueryError error;
    private final String updateType;
    private final Long updateCount;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") List<List<Object>> data, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="updateCount") Long updateCount) {
        this(id, infoUri, partialCancelUri, nextUri, columns, QueryResults.fixData(columns, data), stats, error, updateType, updateCount);
    }

    public QueryResults(String id, URI infoUri, URI partialCancelUri, URI nextUri, List<Column> columns, Iterable<List<Object>> data, StatementStats stats, QueryError error, String updateType, Long updateCount) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data != null ? Iterables.unmodifiableIterable(data) : null;
        Preconditions.checkArgument((data == null || columns != null ? 1 : 0) != 0, (Object)"data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.updateType = updateType;
        this.updateCount = updateCount;
    }

    @Override
    @Nonnull
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    @JsonProperty
    public Iterable<List<Object>> getData() {
        return this.data;
    }

    @Override
    @Nonnull
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @Nullable
    @JsonProperty
    public Long getUpdateCount() {
        return this.updateCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("infoUri", (Object)this.infoUri).add("partialCancelUri", (Object)this.partialCancelUri).add("nextUri", (Object)this.nextUri).add("columns", this.columns).add("hasData", this.data != null).add("stats", (Object)this.stats).add("error", (Object)this.error).add("updateType", (Object)this.updateType).add("updateCount", (Object)this.updateCount).toString();
    }

    @VisibleForTesting
    static Iterable<List<Object>> fixData(List<Column> columns, List<List<Object>> data) {
        if (data == null) {
            return null;
        }
        Objects.requireNonNull(columns, "columns is null");
        List signatures = columns.stream().map(column -> TypeSignature.parseTypeSignature((String)column.getType())).collect(Collectors.toList());
        ImmutableList.Builder rows = ImmutableList.builder();
        for (List<Object> row : data) {
            Preconditions.checkArgument((row.size() == columns.size() ? 1 : 0) != 0, (Object)"row/column size mismatch");
            ArrayList<Object> newRow = new ArrayList<Object>();
            for (int i = 0; i < row.size(); ++i) {
                newRow.add(QueryResults.fixValue((TypeSignature)signatures.get(i), row.get(i)));
            }
            rows.add(Collections.unmodifiableList(newRow));
        }
        return rows.build();
    }

    private static Object fixValue(TypeSignature signature, Object value) {
        if (value == null) {
            return null;
        }
        if (signature.getBase().equals("array")) {
            ArrayList<Object> fixedValue = new ArrayList<Object>();
            for (Object object : (List)List.class.cast(value)) {
                fixedValue.add(QueryResults.fixValue((TypeSignature)signature.getTypeParametersAsTypeSignatures().get(0), object));
            }
            return fixedValue;
        }
        if (signature.getBase().equals("map")) {
            TypeSignature keySignature = (TypeSignature)signature.getTypeParametersAsTypeSignatures().get(0);
            TypeSignature valueSignature = (TypeSignature)signature.getTypeParametersAsTypeSignatures().get(1);
            HashMap<Object, Object> fixedValue = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)Map.class.cast(value)).entrySet()) {
                fixedValue.put(QueryResults.fixValue(keySignature, entry.getKey()), QueryResults.fixValue(valueSignature, entry.getValue()));
            }
            return fixedValue;
        }
        if (signature.getBase().equals("row")) {
            LinkedHashMap<String, Object> fixedValue = new LinkedHashMap<String, Object>();
            List listValue = (List)List.class.cast(value);
            Preconditions.checkArgument((listValue.size() == signature.getParameters().size() ? 1 : 0) != 0, (Object)"Mismatched data values and row type");
            for (int i = 0; i < listValue.size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)signature.getParameters().get(i);
                Preconditions.checkArgument((parameter.getKind() == ParameterKind.NAMED_TYPE ? 1 : 0) != 0, (String)"Unexpected parameter [%s] for row type", (Object)parameter);
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                String key = namedTypeSignature.getName();
                fixedValue.put(key, QueryResults.fixValue(namedTypeSignature.getTypeSignature(), listValue.get(i)));
            }
            return fixedValue;
        }
        switch (signature.getBase()) {
            case "bigint": {
                if (value instanceof String) {
                    return Long.parseLong((String)value);
                }
                return ((Number)value).longValue();
            }
            case "integer": {
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
                return ((Number)value).intValue();
            }
            case "smallint": {
                if (value instanceof String) {
                    return Short.parseShort((String)value);
                }
                return ((Number)value).shortValue();
            }
            case "tinyint": {
                if (value instanceof String) {
                    return Byte.parseByte((String)value);
                }
                return ((Number)value).byteValue();
            }
            case "double": {
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
                return ((Number)value).doubleValue();
            }
            case "real": {
                if (value instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
                return Float.valueOf(((Number)value).floatValue());
            }
            case "boolean": {
                if (value instanceof String) {
                    return Boolean.parseBoolean((String)value);
                }
                return Boolean.class.cast(value);
            }
            case "varchar": 
            case "json": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": 
            case "ipaddress": 
            case "decimal": 
            case "char": 
            case "Geometry": {
                return String.class.cast(value);
            }
        }
        if (value instanceof String) {
            return Base64.getDecoder().decode((String)value);
        }
        return value;
    }
}

