/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.SpnegoHandler;
import com.google.common.net.HostAndPort;
import io.airlift.security.pem.PemReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class OkHttpUtil {
    private OkHttpUtil() {
    }

    public static Interceptor userAgent(String userAgent) {
        return chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build());
    }

    public static Interceptor basicAuth(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        if (user.contains(":")) {
            throw new ClientException("Illegal character ':' found in username");
        }
        String credential = Credentials.basic((String)user, (String)password);
        return chain -> chain.proceed(chain.request().newBuilder().header("Authorization", credential).build());
    }

    public static void setupTimeouts(OkHttpClient.Builder clientBuilder, int timeout, TimeUnit unit) {
        clientBuilder.connectTimeout((long)timeout, unit).readTimeout((long)timeout, unit).writeTimeout((long)timeout, unit);
    }

    public static void setupSocksProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> socksProxy) {
        OkHttpUtil.setupProxy(clientBuilder, socksProxy, Proxy.Type.SOCKS);
    }

    public static void setupHttpProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> httpProxy) {
        OkHttpUtil.setupProxy(clientBuilder, httpProxy, Proxy.Type.HTTP);
    }

    public static void setupProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> proxy, Proxy.Type type) {
        proxy.map(OkHttpUtil::toUnresolvedAddress).map(address -> new Proxy(type, (SocketAddress)address)).ifPresent(arg_0 -> ((OkHttpClient.Builder)clientBuilder).proxy(arg_0));
    }

    private static InetSocketAddress toUnresolvedAddress(HostAndPort address) {
        return InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
    }

    public static void setupSsl(OkHttpClient.Builder clientBuilder, Optional<String> keyStorePath, Optional<String> keyStorePassword, Optional<String> trustStorePath, Optional<String> trustStorePassword) {
        if (!keyStorePath.isPresent() && !trustStorePath.isPresent()) {
            return;
        }
        try {
            KeyStore keyStore = null;
            KeyManager[] keyManagers = null;
            if (keyStorePath.isPresent()) {
                char[] keyManagerPassword;
                try {
                    keyStore = PemReader.loadKeyStore((File)new File(keyStorePath.get()), (File)new File(keyStorePath.get()), keyStorePassword);
                    keyManagerPassword = new char[]{};
                }
                catch (IOException | GeneralSecurityException ignored) {
                    keyManagerPassword = keyStorePassword.map(String::toCharArray).orElse(null);
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream in = new FileInputStream(keyStorePath.get());){
                        keyStore.load(in, keyManagerPassword);
                    }
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, keyManagerPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore trustStore = keyStore;
            if (trustStorePath.isPresent()) {
                trustStore = OkHttpUtil.loadTrustStore(new File(trustStorePath.get()), trustStorePassword);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ClientException("Error setting up SSL: " + e.getMessage(), e);
        }
    }

    private static KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            List certificateChain = PemReader.readCertificateChain((File)trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException certificateChain) {
            // empty catch block
        }
        try (FileInputStream in = new FileInputStream(trustStorePath);){
            trustStore.load(in, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }

    public static void setupKerberos(OkHttpClient.Builder clientBuilder, String remoteServiceName, boolean useCanonicalHostname, Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache) {
        SpnegoHandler handler = new SpnegoHandler(remoteServiceName, useCanonicalHostname, principal, kerberosConfig, keytab, credentialCache);
        clientBuilder.addInterceptor((Interceptor)handler);
        clientBuilder.authenticator((Authenticator)handler);
    }

    public static class NullCallback
    implements Callback {
        public void onFailure(Call call, IOException e) {
        }

        public void onResponse(Call call, Response response) {
        }
    }
}

