/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.OutputPrinter;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OutputHandler
implements Closeable {
    private static final Duration MAX_BUFFER_TIME = new Duration(3.0, TimeUnit.SECONDS);
    private static final int MAX_BUFFERED_ROWS = 10000;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final List<List<?>> rowBuffer = new ArrayList(10000);
    private final OutputPrinter printer;
    private long bufferStart;

    public OutputHandler(OutputPrinter printer) {
        this.printer = (OutputPrinter)Preconditions.checkNotNull((Object)printer, (Object)"printer is null");
    }

    public void processRow(List<?> row) throws IOException {
        if (this.rowBuffer.isEmpty()) {
            this.bufferStart = System.nanoTime();
        }
        this.rowBuffer.add(row);
        if (this.rowBuffer.size() >= 10000) {
            this.flush(false);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.flush(true);
            this.printer.finish();
        }
    }

    public void processRows(StatementClient client) throws IOException {
        while (client.isValid()) {
            Iterable data = client.current().getData();
            if (data != null) {
                for (List tuple : data) {
                    this.processRow(Collections.unmodifiableList(tuple));
                }
            }
            if (Duration.nanosSince((long)this.bufferStart).compareTo(MAX_BUFFER_TIME) >= 0) {
                this.flush(false);
            }
            client.advance();
        }
    }

    private void flush(boolean complete) throws IOException {
        if (!this.rowBuffer.isEmpty()) {
            this.printer.printRows(Collections.unmodifiableList(this.rowBuffer), complete);
            this.rowBuffer.clear();
        }
    }
}

