/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Command(name="presto", description="Presto interactive console")
public class PerfTest {
    private static final String USER_AGENT_VALUE = PerfTest.class.getSimpleName() + "/" + (String)MoreObjects.firstNonNull((Object)PerfTest.class.getPackage().getImplementationVersion(), (Object)"unknown");
    @Inject
    public HelpOption helpOption;
    @Option(name={"--server"}, title="server", description="Presto server location (default: localhost:8080)")
    public String server = "localhost:8080";
    @Option(name={"--catalog"}, title="catalog", description="Default catalog")
    public String catalog;
    @Option(name={"--schema"}, title="schema", description="Default schema")
    public String schema;
    @Option(name={"-f", "--file"}, title="file", description="Execute statements from file and exit")
    public String file;
    @Option(name={"--debug"}, title="debug", description="Enable debug information")
    public boolean debug;
    @Option(name={"-r", "--runs"}, title="number", description="Number of runs until exit (default: 10)")
    public int runs = 10;
    @Option(name={"--timeout"}, title="timeout", description="Timeout for HTTP-Client to wait for query results (default: 600)")
    public int timeout = 600;
    @Option(name={"--client-request-timeout"}, title="client request timeout", description="Client request timeout (default: 2m)")
    public Duration clientRequestTimeout = new Duration(2.0, TimeUnit.MINUTES);

    public void run() throws Exception {
        PerfTest.initializeLogging(this.debug);
        List<String> queries = this.loadQueries();
        try (ParallelQueryRunner parallelQueryRunner = new ParallelQueryRunner(16, ClientOptions.parseServer(this.server), this.catalog, this.schema, this.debug, this.timeout, this.clientRequestTimeout);){
            for (int loop = 0; loop < this.runs; ++loop) {
                PerfTest.executeQueries(queries, parallelQueryRunner, 1);
                PerfTest.executeQueries(queries, parallelQueryRunner, 2);
                PerfTest.executeQueries(queries, parallelQueryRunner, 4);
                PerfTest.executeQueries(queries, parallelQueryRunner, 8);
                PerfTest.executeQueries(queries, parallelQueryRunner, 16);
            }
        }
    }

    private static void executeQueries(List<String> queries, ParallelQueryRunner parallelQueryRunner, int parallelism) throws Exception {
        Duration duration = parallelQueryRunner.executeCommands(parallelism, queries);
        System.out.printf("%2d: %s\n", parallelism, duration.convertTo(TimeUnit.SECONDS));
    }

    private List<String> loadQueries() {
        try {
            String query = Files.toString((File)new File(this.file), (Charset)StandardCharsets.UTF_8);
            StatementSplitter splitter = new StatementSplitter(query + ";");
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)splitter.getCompleteStatements(), StatementSplitter.Statement::statement));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error reading from file %s: %s", this.file, e.getMessage()));
        }
    }

    private static void initializeLogging(boolean debug) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            if (debug) {
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.setLevel("com.facebook.presto", Level.DEBUG);
            } else {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.disableConsole();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static void main(String[] args) throws Exception {
        PerfTest perfTest = (PerfTest)SingleCommand.singleCommand(PerfTest.class).parse(args);
        if (perfTest.helpOption.showHelpIfRequested()) {
            return;
        }
        perfTest.run();
    }

    public static class QueryRunner
    implements Closeable {
        private final ClientSession session;
        private final ListeningExecutorService executor;
        private final HttpClient httpClient;

        public QueryRunner(ClientSession session, ListeningExecutorService executor, int timeout) {
            this.session = session;
            this.executor = executor;
            HttpClientConfig clientConfig = new HttpClientConfig();
            clientConfig.setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS));
            clientConfig.setIdleTimeout(new Duration((double)timeout, TimeUnit.SECONDS));
            this.httpClient = new JettyHttpClient(clientConfig);
        }

        public ListenableFuture<?> execute(BlockingQueue<String> queue, CountDownLatch remainingQueries) {
            return this.executor.submit(() -> {
                String query = (String)queue.poll();
                while (query != null) {
                    this.execute(query);
                    remainingQueries.countDown();
                    query = (String)queue.poll();
                }
            });
        }

        public void execute(String query) {
            Request request = QueryRunner.buildQueryRequest(this.session, query);
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            if (response.getStatusCode() != 200) {
                throw new RuntimeException("Query failed: [" + response.getStatusCode() + "] " + response.getStatusMessage());
            }
        }

        private static Request buildQueryRequest(ClientSession session, String query) {
            Request.Builder builder = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)session.getServer()).replacePath("/v1/execute").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8));
            if (session.getUser() != null) {
                builder.setHeader("X-Presto-User", session.getUser());
            }
            if (session.getSource() != null) {
                builder.setHeader("X-Presto-Source", session.getSource());
            }
            if (session.getCatalog() != null) {
                builder.setHeader("X-Presto-Catalog", session.getCatalog());
            }
            if (session.getSchema() != null) {
                builder.setHeader("X-Presto-Schema", session.getSchema());
            }
            builder.setHeader("X-Presto-Time-Zone", session.getTimeZone().getId());
            builder.setHeader("User-Agent", USER_AGENT_VALUE);
            return builder.build();
        }

        @Override
        public void close() {
            this.httpClient.close();
        }
    }

    public static class ParallelQueryRunner
    implements Closeable {
        private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"query-runner-%s")));
        private final List<QueryRunner> runners;

        public ParallelQueryRunner(int maxParallelism, URI server, String catalog, String schema, boolean debug, int timeout, Duration clientRequestTimeout) {
            ImmutableList.Builder runners = ImmutableList.builder();
            for (int i = 0; i < maxParallelism; ++i) {
                ClientSession session = new ClientSession(server, "test-" + i, "presto-perf", null, catalog, schema, TimeZone.getDefault().getID(), Locale.getDefault(), (Map)ImmutableMap.of(), null, debug, clientRequestTimeout);
                runners.add((Object)new QueryRunner(session, this.executor, timeout));
            }
            this.runners = runners.build();
        }

        public Duration executeCommands(int parallelism, List<String> queries) throws Exception {
            Preconditions.checkArgument((parallelism >= 0 ? 1 : 0) != 0, (Object)"parallelism is negative");
            Preconditions.checkArgument((parallelism <= this.runners.size() ? 1 : 0) != 0, (Object)"parallelism is greater than maxParallelism");
            Objects.requireNonNull(queries, "queries is null");
            CountDownLatch remainingQueries = new CountDownLatch(queries.size());
            ArrayBlockingQueue<String> queue = new ArrayBlockingQueue<String>(queries.size(), false, queries);
            ArrayList futures = new ArrayList(parallelism);
            long start = System.nanoTime();
            for (int i = 0; i < parallelism; ++i) {
                QueryRunner runner = this.runners.get(i);
                futures.add(runner.execute(queue, remainingQueries));
            }
            ListenableFuture allFutures = Futures.allAsList(futures);
            Futures.addCallback((ListenableFuture)allFutures, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> result) {
                }

                public void onFailure(Throwable t) {
                    System.err.println("Run failed");
                    t.printStackTrace(System.err);
                    System.exit(1);
                }
            }, (Executor)this.executor);
            remainingQueries.await();
            Duration executionTime = Duration.nanosSince((long)start);
            allFutures.get();
            return executionTime;
        }

        @Override
        public void close() throws IOException {
            for (QueryRunner runner : this.runners) {
                try {
                    runner.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

