/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.Query;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class QueryRunner
implements Closeable {
    private final JsonCodec<QueryResults> queryResultsCodec;
    private final AtomicReference<ClientSession> session;
    private final HttpClient httpClient;

    public QueryRunner(ClientSession session, JsonCodec<QueryResults> queryResultsCodec, Optional<HostAndPort> socksProxy) {
        this.session = new AtomicReference<Object>(Preconditions.checkNotNull((Object)session, (Object)"session is null"));
        this.queryResultsCodec = (JsonCodec)Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
        this.httpClient = new JettyHttpClient(QueryRunner.getHttpClientConfig(socksProxy));
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setSession(ClientSession session) {
        this.session.set((ClientSession)Preconditions.checkNotNull((Object)session, (Object)"session is null"));
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(query));
    }

    public StatementClient startInternalQuery(String query) {
        return new StatementClient(this.httpClient, this.queryResultsCodec, this.session.get(), query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public static QueryRunner create(ClientSession session, Optional<HostAndPort> socksProxy) {
        return new QueryRunner(session, (JsonCodec<QueryResults>)JsonCodec.jsonCodec(QueryResults.class), socksProxy);
    }

    private static HttpClientConfig getHttpClientConfig(Optional<HostAndPort> socksProxy) {
        HttpClientConfig httpClientConfig = new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS));
        if (socksProxy.isPresent()) {
            httpClientConfig.setSocksProxy(socksProxy.get());
        }
        return httpClientConfig;
    }
}

