/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.filemerge;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import java.util.concurrent.TimeUnit;

public class FileMergeCacheConfig {
    private int maxCachedEntries = 1000;
    private Duration cacheTtl = new Duration(2.0, TimeUnit.DAYS);
    private DataSize maxInMemoryCacheSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);

    @Min(value=1L)
    public @Min(value=1L) int getMaxCachedEntries() {
        return this.maxCachedEntries;
    }

    @Config(value="cache.max-cached-entries")
    @ConfigDescription(value="Number of entries allowed in the cache")
    public FileMergeCacheConfig setMaxCachedEntries(int maxCachedEntries) {
        this.maxCachedEntries = maxCachedEntries;
        return this;
    }

    public DataSize getMaxInMemoryCacheSize() {
        return this.maxInMemoryCacheSize;
    }

    @Config(value="cache.max-in-memory-cache-size")
    @ConfigDescription(value="The maximum cache size allowed in memory")
    public FileMergeCacheConfig setMaxInMemoryCacheSize(DataSize maxInMemoryCacheSize) {
        this.maxInMemoryCacheSize = maxInMemoryCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public @MinDuration(value="0s") Duration getCacheTtl() {
        return this.cacheTtl;
    }

    @Config(value="cache.ttl")
    @ConfigDescription(value="Time-to-live for a cache entry")
    public FileMergeCacheConfig setCacheTtl(Duration cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }
}

