/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheFactory;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CacheStats;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.cache.NoOpCacheManager;
import com.facebook.presto.cache.alluxio.AlluxioCacheConfig;
import com.facebook.presto.cache.alluxio.AlluxioCachingConfigurationProvider;
import com.facebook.presto.cache.filemerge.FileMergeCacheConfig;
import com.facebook.presto.cache.filemerge.FileMergeCacheManager;
import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public class CachingModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(CacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CacheStats.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(CacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileMergeCacheConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioCacheConfig.class);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(AlluxioCachingConfigurationProvider.class).in(Scopes.SINGLETON);
        binder.bind(CacheFactory.class).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public CacheManager createCacheManager(CacheConfig cacheConfig, FileMergeCacheConfig fileMergeCacheConfig, CacheStats cacheStats) {
        if (cacheConfig.isCachingEnabled() && cacheConfig.getCacheType() == CacheType.FILE_MERGE) {
            return new FileMergeCacheManager(cacheConfig, fileMergeCacheConfig, cacheStats, Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"hive-cache-flusher-%s")), Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"hive-cache-remover-%s")), Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"hive-cache-size-calculator-%s")));
        }
        return new NoOpCacheManager();
    }
}

