/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CacheStats {
    private final AtomicLong inMemoryRetainedBytes = new AtomicLong();
    private final AtomicLong hit = new AtomicLong();
    private final AtomicLong miss = new AtomicLong();
    private final AtomicLong quotaExceed = new AtomicLong();

    public void incrementCacheHit() {
        this.hit.getAndIncrement();
    }

    public void incrementCacheMiss() {
        this.miss.getAndIncrement();
    }

    public void incrementQuotaExceed() {
        this.quotaExceed.getAndIncrement();
    }

    public void addInMemoryRetainedBytes(long bytes) {
        this.inMemoryRetainedBytes.addAndGet(bytes);
    }

    @Managed
    public long getInMemoryRetainedBytes() {
        return this.inMemoryRetainedBytes.get();
    }

    @Managed
    public long getCacheHit() {
        return this.hit.get();
    }

    @Managed
    public long getCacheMiss() {
        return this.miss.get();
    }

    @Managed
    public long getQuotaExceed() {
        return this.quotaExceed.get();
    }
}

