/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.CacheContext;
import alluxio.client.quota.CacheQuota;
import alluxio.client.quota.CacheScope;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.hive.HiveFileContext;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.Objects;

public class PrestoCacheContext
extends CacheContext {
    private final HiveFileContext hiveFileContext;

    public static PrestoCacheContext build(String cacheIdentifier, HiveFileContext hiveFileContext, boolean cacheQuotaEnabled) {
        PrestoCacheContext context = new PrestoCacheContext(hiveFileContext);
        context.setCacheIdentifier(cacheIdentifier);
        if (cacheQuotaEnabled) {
            CacheScope scope = CacheScope.create((String)hiveFileContext.getCacheQuota().getIdentity());
            context.setCacheScope(scope);
            if (hiveFileContext.getCacheQuota().getQuota().isPresent()) {
                context.setCacheQuota(new CacheQuota((Map)ImmutableMap.of((Object)scope.level(), (Object)((DataSize)hiveFileContext.getCacheQuota().getQuota().get()).toBytes())));
            } else {
                context.setCacheQuota(CacheQuota.UNLIMITED);
            }
        }
        return context;
    }

    private PrestoCacheContext(HiveFileContext hiveFileContext) {
        this.hiveFileContext = Objects.requireNonNull(hiveFileContext, "hiveFileContext is null");
    }

    public void incrementCounter(String name, CacheContext.StatsUnit unit, long value) {
        switch (unit) {
            case BYTE: {
                this.hiveFileContext.incrementCounter(name, RuntimeUnit.BYTE, value);
                break;
            }
            case NANO: {
                this.hiveFileContext.incrementCounter(name, RuntimeUnit.NANO, value);
                break;
            }
            default: {
                this.hiveFileContext.incrementCounter(name, RuntimeUnit.NONE, value);
            }
        }
    }

    public HiveFileContext getHiveFileContext() {
        return this.hiveFileContext;
    }
}

