/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheType;
import com.facebook.presto.cache.alluxio.AlluxioCacheConfig;
import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.HdfsContext;
import java.net.URI;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class AlluxioCachingConfigurationProvider
implements DynamicConfigurationProvider {
    private final CacheConfig cacheConfig;
    private final AlluxioCacheConfig alluxioCacheConfig;

    @Inject
    public AlluxioCachingConfigurationProvider(CacheConfig cacheConfig, AlluxioCacheConfig alluxioCacheConfig) {
        this.cacheConfig = cacheConfig;
        this.alluxioCacheConfig = alluxioCacheConfig;
    }

    public void updateConfiguration(Configuration configuration, HdfsContext context, URI uri) {
        if (this.cacheConfig.isCachingEnabled() && this.cacheConfig.getCacheType() == CacheType.ALLUXIO) {
            configuration.set("alluxio.user.local.cache.enabled", String.valueOf(this.cacheConfig.isCachingEnabled()));
            if (this.cacheConfig.getBaseDirectory() != null) {
                configuration.set("alluxio.user.client.cache.dir", this.cacheConfig.getBaseDirectory().getPath());
            }
            configuration.set("alluxio.user.client.cache.size", this.alluxioCacheConfig.getMaxCacheSize().toString());
            configuration.set("alluxio.user.client.cache.async.write.enabled", String.valueOf(this.alluxioCacheConfig.isAsyncWriteEnabled()));
            configuration.set("alluxio.user.metrics.collection.enabled", String.valueOf(this.alluxioCacheConfig.isMetricsCollectionEnabled()));
            configuration.set("alluxio.user.client.cache.eviction.retries", String.valueOf(this.alluxioCacheConfig.getEvictionRetries()));
            configuration.set("alluxio.user.client.cache.evictor.class", this.alluxioCacheConfig.getEvictionPolicy().getClassName());
            configuration.set("alluxio.user.client.cache.quota.enabled", String.valueOf(this.alluxioCacheConfig.isCacheQuotaEnabled()));
            configuration.set("sink.jmx.class", this.alluxioCacheConfig.getJmxClass());
            configuration.set("sink.jmx.domain", this.alluxioCacheConfig.getMetricsDomain());
            configuration.set("alluxio.conf.validation.enabled", String.valueOf(this.alluxioCacheConfig.isConfigValidationEnabled()));
            if (this.alluxioCacheConfig.getTimeoutEnabled()) {
                configuration.set("alluxio.user.client.cache.timeout.duration", String.valueOf(this.alluxioCacheConfig.getTimeoutDuration().toMillis()));
                configuration.set("alluxio.user.client.cache.timeout.threads", String.valueOf(this.alluxioCacheConfig.getTimeoutThreads()));
            } else {
                configuration.set("alluxio.user.client.cache.timeout.duration", "-1");
            }
        }
    }
}

