/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.cache.alluxio.EvictionPolicy;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;

public class AlluxioCacheConfig {
    private boolean metricsCollectionEnabled = true;
    private boolean asyncWriteEnabled;
    private String jmxClass = "alluxio.metrics.sink.JmxSink";
    private String metricsDomain = "com.facebook.alluxio";
    private DataSize maxCacheSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private boolean configValidationEnabled;
    private boolean timeoutEnabled = true;
    private boolean cacheQuotaEnabled;
    private Duration timeoutDuration = new Duration(60.0, TimeUnit.SECONDS);
    private int timeoutThreads = 64;
    private int evictionRetries = 10;
    private EvictionPolicy evictionPolicy = EvictionPolicy.LRU;

    public boolean isMetricsCollectionEnabled() {
        return this.metricsCollectionEnabled;
    }

    @Config(value="cache.alluxio.metrics-enabled")
    @ConfigDescription(value="If metrics for alluxio caching are enabled")
    public AlluxioCacheConfig setMetricsCollectionEnabled(boolean metricsCollectionEnabled) {
        this.metricsCollectionEnabled = metricsCollectionEnabled;
        return this;
    }

    public String getJmxClass() {
        return this.jmxClass;
    }

    @Config(value="cache.alluxio.jmx-class")
    @ConfigDescription(value="JMX class name used by the alluxio caching for metrics")
    public AlluxioCacheConfig setJmxClass(String jmxClass) {
        this.jmxClass = jmxClass;
        return this;
    }

    public String getMetricsDomain() {
        return this.metricsDomain;
    }

    @Config(value="cache.alluxio.metrics-domain")
    @ConfigDescription(value="Metrics domain name used by the alluxio caching")
    public AlluxioCacheConfig setMetricsDomain(String metricsDomain) {
        this.metricsDomain = metricsDomain;
        return this;
    }

    public boolean isAsyncWriteEnabled() {
        return this.asyncWriteEnabled;
    }

    @Config(value="cache.alluxio.async-write-enabled")
    @ConfigDescription(value="If alluxio caching should write to cache asynchronously")
    public AlluxioCacheConfig setAsyncWriteEnabled(boolean asyncWriteEnabled) {
        this.asyncWriteEnabled = asyncWriteEnabled;
        return this;
    }

    public DataSize getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Config(value="cache.alluxio.max-cache-size")
    @ConfigDescription(value="The maximum cache size available for alluxio cache")
    public AlluxioCacheConfig setMaxCacheSize(DataSize maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    @Config(value="cache.alluxio.config-validation-enabled")
    @ConfigDescription(value="If the alluxio caching should validate the provided configuration")
    public AlluxioCacheConfig setConfigValidationEnabled(boolean configValidationEnabled) {
        this.configValidationEnabled = configValidationEnabled;
        return this;
    }

    public boolean isConfigValidationEnabled() {
        return this.configValidationEnabled;
    }

    public int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="cache.alluxio.timeout-threads")
    @ConfigDescription(value="Number of threads used to handle timeouts in alluxio caching")
    public AlluxioCacheConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    public Duration getTimeoutDuration() {
        return this.timeoutDuration;
    }

    @Config(value="cache.alluxio.timeout-duration")
    @ConfigDescription(value="Timeout duration for alluxio caching operations")
    public AlluxioCacheConfig setTimeoutDuration(Duration timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        return this;
    }

    public boolean getTimeoutEnabled() {
        return this.timeoutEnabled;
    }

    @Config(value="cache.alluxio.timeout-enabled")
    @ConfigDescription(value="Whether to enable timeout for alluxio caching operations")
    public AlluxioCacheConfig setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
        return this;
    }

    public int getEvictionRetries() {
        return this.evictionRetries;
    }

    @Config(value="cache.alluxio.eviction-retries")
    @ConfigDescription(value="The maximum number of eviction retries")
    public AlluxioCacheConfig setEvictionRetries(int evictionRetries) {
        this.evictionRetries = evictionRetries;
        return this;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Config(value="cache.alluxio.eviction-policy")
    @ConfigDescription(value="The cache eviction policy")
    public AlluxioCacheConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public boolean isCacheQuotaEnabled() {
        return this.cacheQuotaEnabled;
    }

    @Config(value="cache.alluxio.quota-enabled")
    @ConfigDescription(value="Whether to enable quota for alluxio caching operations")
    public AlluxioCacheConfig setCacheQuotaEnabled(boolean cacheQuotaEnabled) {
        this.cacheQuotaEnabled = cacheQuotaEnabled;
        return this;
    }
}

