/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.URIStatus;
import alluxio.wire.FileInfo;
import com.facebook.presto.hive.HiveFileContext;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;

public class AlluxioURIStatus
extends URIStatus {
    private final HiveFileContext hiveFileContext;

    private static FileInfo toAlluxioFileInfo(FileStatus status) {
        FileInfo info = new FileInfo();
        info.setFileIdentifier(Hashing.md5().hashString((CharSequence)status.getPath().toString(), StandardCharsets.UTF_8).toString()).setLength(status.getLen()).setPath(status.getPath().toString()).setFolder(status.isDirectory()).setBlockSizeBytes(status.getBlockSize()).setLastModificationTimeMs(status.getModificationTime()).setLastAccessTimeMs(status.getAccessTime()).setOwner(status.getOwner()).setGroup(status.getGroup());
        return info;
    }

    public AlluxioURIStatus(FileStatus fileStatus, HiveFileContext hiveFileContext) {
        super(AlluxioURIStatus.toAlluxioFileInfo(fileStatus));
        this.hiveFileContext = Objects.requireNonNull(hiveFileContext, "hiveFileContext is null");
    }

    public HiveFileContext getHiveFileContext() {
        return this.hiveFileContext;
    }
}

