/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.client.file.FileInStream;
import alluxio.exception.ExceptionMessage;
import com.google.common.base.Verify;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class AlluxioCachingHdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final FileInStream inputStream;
    private final Optional<FSDataInputStream> dataTierInputStream;
    private final boolean cacheValidationEnabled;

    public AlluxioCachingHdfsFileInputStream(FileInStream inputStream) {
        this(inputStream, Optional.empty(), false);
    }

    public AlluxioCachingHdfsFileInputStream(FileInStream inputStream, Optional<FSDataInputStream> dataTierInputStream, boolean cacheValidationEnabled) {
        this.inputStream = Objects.requireNonNull(inputStream, "InputStream is null");
        this.dataTierInputStream = Objects.requireNonNull(dataTierInputStream, "DataTierInputStream is null");
        Verify.verify((!cacheValidationEnabled || dataTierInputStream.isPresent() ? 1 : 0) != 0, (String)"data tier input need to be non-null for data validation.", (Object[])new Object[0]);
        this.cacheValidationEnabled = cacheValidationEnabled;
    }

    @Override
    public int read() throws IOException {
        int outByte = this.inputStream.read();
        if (this.cacheValidationEnabled) {
            Verify.verify((this.dataTierInputStream.get().read() == outByte ? 1 : 0) != 0, (String)("corrupted buffer at position " + this.getPos()), (Object[])new Object[0]);
        }
        return outByte;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytes = this.inputStream.positionedRead(position, buffer, offset, length);
        if (this.cacheValidationEnabled) {
            byte[] validationBuffer = new byte[bytes];
            this.dataTierInputStream.get().read(position, validationBuffer, 0, bytes);
            for (int i = 0; i < bytes; ++i) {
                Verify.verify((buffer[offset + i] == validationBuffer[i] ? 1 : 0) != 0, (String)("corrupted buffer at position " + i), (Object[])new Object[0]);
            }
        }
        return bytes;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long position) throws IOException {
        this.inputStream.seek(position);
        if (this.cacheValidationEnabled) {
            this.dataTierInputStream.get().seek(position);
        }
    }

    public long getPos() throws IOException {
        return this.inputStream.getPos();
    }

    public boolean seekToNewSource(long target) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }
}

