/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.PMode;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.Mode;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import com.facebook.presto.cache.alluxio.AlluxioCachingInputStream;
import com.facebook.presto.cache.alluxio.AlluxioURIStatus;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class AlluxioCachingClientFileSystem
implements FileSystem {
    private final AlluxioConfiguration alluxioConfiguration;
    private final ExtendedFileSystem fileSystem;

    public AlluxioCachingClientFileSystem(ExtendedFileSystem fileSystem, AlluxioConfiguration alluxioConfiguration) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.alluxioConfiguration = Objects.requireNonNull(alluxioConfiguration, "alluxioConfiguration is null");
    }

    public void createDirectory(AlluxioURI alluxioURI, CreateDirectoryPOptions options) throws IOException {
        FsPermission permission = new FsPermission(Mode.fromProto((PMode)options.getMode()).toShort());
        this.fileSystem.mkdirs(this.toPath(alluxioURI), permission);
    }

    public FileInStream openFile(AlluxioURI alluxioURI, OpenFilePOptions options) throws IOException {
        return new AlluxioCachingInputStream(this.fileSystem.open(this.toPath(alluxioURI)));
    }

    public FileInStream openFile(URIStatus uriStatus, OpenFilePOptions options) throws IOException {
        Preconditions.checkState((boolean)(uriStatus instanceof AlluxioURIStatus));
        HiveFileContext hiveFileContext = ((AlluxioURIStatus)uriStatus).getHiveFileContext();
        try {
            return new AlluxioCachingInputStream(this.fileSystem.openFile(new Path(uriStatus.getPath()), hiveFileContext));
        }
        catch (Exception e) {
            throw new IOException("Failed to open file", e);
        }
    }

    public FileOutStream createFile(AlluxioURI alluxioURI, CreateFilePOptions options) {
        throw new UnsupportedOperationException("CreateFile operation is not supported");
    }

    public void delete(AlluxioURI alluxioURI, DeletePOptions options) {
        throw new UnsupportedOperationException("Delete operation is not supported");
    }

    public boolean exists(AlluxioURI alluxioURI, ExistsPOptions options) {
        throw new UnsupportedOperationException("Exists operation is not supported");
    }

    public AlluxioConfiguration getConf() {
        return this.alluxioConfiguration;
    }

    public URIStatus getStatus(AlluxioURI alluxioURI, GetStatusPOptions options) throws IOException {
        return this.toUriStatus(this.fileSystem.getFileStatus(this.toPath(alluxioURI)));
    }

    public List<URIStatus> listStatus(AlluxioURI alluxioURI, ListStatusPOptions options) throws IOException {
        return Arrays.stream(this.fileSystem.listStatus(this.toPath(alluxioURI))).map(this::toUriStatus).collect(Collectors.toList());
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException("isClosed is not supported");
    }

    public void free(AlluxioURI alluxioURI, FreePOptions options) {
        throw new UnsupportedOperationException("Free is not supported.");
    }

    public List<BlockLocationInfo> getBlockLocations(AlluxioURI alluxioURI) {
        throw new UnsupportedOperationException("GetBlockLocations is not supported.");
    }

    public void mount(AlluxioURI alluxioURI1, AlluxioURI alluxioURI2, MountPOptions options) {
        throw new UnsupportedOperationException("Mount is not supported.");
    }

    public void updateMount(AlluxioURI alluxioURI, MountPOptions options) {
        throw new UnsupportedOperationException("UpdateMount is not supported.");
    }

    public Map<String, MountPointInfo> getMountTable() {
        throw new UnsupportedOperationException("GetMountTable is not supported.");
    }

    public List<SyncPointInfo> getSyncPathList() {
        throw new UnsupportedOperationException("GetSyncPathList is not supported.");
    }

    public void persist(AlluxioURI alluxioURI, ScheduleAsyncPersistencePOptions options) {
        throw new UnsupportedOperationException("Persist is not supported.");
    }

    public void rename(AlluxioURI source, AlluxioURI destination, RenamePOptions options) {
        throw new UnsupportedOperationException("ReverseResolve is not supported.");
    }

    public AlluxioURI reverseResolve(AlluxioURI alluxioURI) {
        throw new UnsupportedOperationException("ReverseResolve is not supported.");
    }

    public void setAcl(AlluxioURI alluxioURI, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) {
        throw new UnsupportedOperationException("SetAcl is not supported.");
    }

    public void startSync(AlluxioURI alluxioURI) {
        throw new UnsupportedOperationException("StartSync is not supported.");
    }

    public void stopSync(AlluxioURI alluxioURI) {
        throw new UnsupportedOperationException("StopSync is not supported.");
    }

    public void setAttribute(AlluxioURI alluxioURI, SetAttributePOptions options) {
        throw new UnsupportedOperationException("SetAttribute is not supported.");
    }

    public void unmount(AlluxioURI alluxioURI, UnmountPOptions options) {
        throw new UnsupportedOperationException("unmount is not supported.");
    }

    public void close() throws IOException {
        this.fileSystem.close();
    }

    private Path toPath(AlluxioURI alluxioURI) {
        return new Path(alluxioURI.toString());
    }

    private URIStatus toUriStatus(FileStatus status) {
        FileInfo info = new FileInfo();
        info.setFileIdentifier(Hashing.md5().hashString((CharSequence)status.getPath().toString(), StandardCharsets.UTF_8).toString());
        info.setLength(status.getLen()).setPath(status.getPath().toString());
        info.setFolder(status.isDirectory()).setBlockSizeBytes(status.getBlockSize());
        info.setLastModificationTimeMs(status.getModificationTime()).setLastAccessTimeMs(status.getAccessTime());
        info.setOwner(status.getOwner()).setGroup(status.getGroup());
        return new URIStatus(info);
    }
}

