/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;

public class AlluxioCacheConfig {
    private boolean metricsCollectionEnabled = true;
    private boolean asyncWriteEnabled;
    private String jmxClass = "alluxio.metrics.sink.JmxSink";
    private String metricsDomain = "com.facebook.alluxio";
    private DataSize maxCacheSize = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private boolean configValidationEnabled;

    public boolean isMetricsCollectionEnabled() {
        return this.metricsCollectionEnabled;
    }

    @Config(value="cache.alluxio.metrics-enabled")
    @ConfigDescription(value="If metrics for alluxio caching are enabled")
    public AlluxioCacheConfig setMetricsCollectionEnabled(boolean metricsCollectionEnabled) {
        this.metricsCollectionEnabled = metricsCollectionEnabled;
        return this;
    }

    public String getJmxClass() {
        return this.jmxClass;
    }

    @Config(value="cache.alluxio.jmx-class")
    @ConfigDescription(value="JMX class name used by the alluxio caching for metrics")
    public AlluxioCacheConfig setJmxClass(String jmxClass) {
        this.jmxClass = jmxClass;
        return this;
    }

    public String getMetricsDomain() {
        return this.metricsDomain;
    }

    @Config(value="cache.alluxio.metrics-domain")
    @ConfigDescription(value="Metrics domain name used by the alluxio caching")
    public AlluxioCacheConfig setMetricsDomain(String metricsDomain) {
        this.metricsDomain = metricsDomain;
        return this;
    }

    public boolean isAsyncWriteEnabled() {
        return this.asyncWriteEnabled;
    }

    @Config(value="cache.alluxio.async-write-enabled")
    @ConfigDescription(value="If alluxio caching should write to cache asynchronously")
    public AlluxioCacheConfig setAsyncWriteEnabled(boolean asyncWriteEnabled) {
        this.asyncWriteEnabled = asyncWriteEnabled;
        return this;
    }

    public DataSize getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Config(value="cache.alluxio.max-cache-size")
    @ConfigDescription(value="The maximum cache size available for alluxio cache")
    public AlluxioCacheConfig setMaxCacheSize(DataSize maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    @Config(value="cache.alluxio.config-validation-enabled")
    @ConfigDescription(value="If the alluxio caching should validate the provided configuration")
    public AlluxioCacheConfig setConfigValidationEnabled(boolean configValidationEnabled) {
        this.configValidationEnabled = configValidationEnabled;
        return this;
    }

    public boolean isConfigValidationEnabled() {
        return this.configValidationEnabled;
    }
}

