/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache.alluxio;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.LocalCacheFileSystem;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.grpc.OpenFilePOptions;
import alluxio.hadoop.AbstractFileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import alluxio.util.ConfigurationUtils;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.alluxio.AlluxioCachingClientFileSystem;
import com.facebook.presto.cache.alluxio.AlluxioCachingHdfsFileInputStream;
import com.facebook.presto.cache.alluxio.AlluxioURIStatus;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public class AlluxioCachingFileSystem
extends CachingFileSystem {
    private AlluxioCachingFileSystemInternal cachingFileSystem;

    public AlluxioCachingFileSystem(ExtendedFileSystem dataTier, URI uri) {
        super(dataTier, uri);
    }

    @Override
    public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
        this.cachingFileSystem = new AlluxioCachingFileSystemInternal(uri, this.dataTier);
        this.cachingFileSystem.initialize(uri, configuration);
    }

    @Override
    public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
        if (hiveFileContext.isCacheable()) {
            return this.cachingFileSystem.openFile(path, hiveFileContext);
        }
        return this.dataTier.openFile(path, hiveFileContext);
    }

    private static class AlluxioCachingFileSystemInternal
    extends AbstractFileSystem {
        private final URI uri;
        private final ExtendedFileSystem fileSystem;

        AlluxioCachingFileSystemInternal(URI uri, ExtendedFileSystem fileSystem) {
            this.uri = Objects.requireNonNull(uri, "uri is null");
            this.fileSystem = Objects.requireNonNull(fileSystem, "filesystem is null");
        }

        public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
            this.setConf(configuration);
            this.statistics = AlluxioCachingFileSystemInternal.getStatistics((String)uri.getScheme(), ((Object)((Object)this)).getClass());
            Map<String, Object> configurationFromUri = this.getConfigurationFromUri(uri);
            AlluxioProperties alluxioProperties = ConfigurationUtils.defaults();
            InstancedConfiguration newConfiguration = HadoopConfigurationUtils.mergeHadoopConfiguration((Configuration)configuration, (AlluxioProperties)alluxioProperties);
            newConfiguration.merge(configurationFromUri, Source.RUNTIME);
            this.mAlluxioConf = newConfiguration;
            Properties metricsProperties = new Properties();
            for (Map.Entry entry : configuration) {
                metricsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            MetricsSystem.startSinksFromConfig((MetricsConfig)new MetricsConfig(metricsProperties));
            this.mFileSystem = new LocalCacheFileSystem((FileSystem)new AlluxioCachingClientFileSystem(this.fileSystem, this.mAlluxioConf), this.mAlluxioConf);
            super.initialize(uri, configuration);
        }

        public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
            URIStatus uriStatus = this.mFileSystem.getStatus(this.getAlluxioPath(path));
            AlluxioURIStatus alluxioURIStatus = new AlluxioURIStatus(uriStatus.getFileInfo(), hiveFileContext);
            FileInStream fileInStream = this.mFileSystem.openFile((URIStatus)alluxioURIStatus, OpenFilePOptions.getDefaultInstance());
            return new FSDataInputStream((InputStream)new AlluxioCachingHdfsFileInputStream(fileInStream));
        }

        public String getScheme() {
            return this.uri.getScheme();
        }

        protected boolean isZookeeperMode() {
            return this.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED);
        }

        protected Map<String, Object> getConfigurationFromUri(URI uri) {
            return ImmutableMap.of();
        }

        protected void validateFsUri(URI uri) {
        }

        protected String getFsScheme(URI uri) {
            return this.getScheme();
        }

        protected AlluxioURI getAlluxioPath(Path path) {
            return new AlluxioURI(path.toString());
        }

        protected Path getFsPath(String uriHeader, URIStatus fileStatus) {
            return new Path(uriHeader + fileStatus.getPath());
        }
    }
}

